package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Represents an app in the list of managed applications”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "publisher", 
    "appStoreUrl", 
    "appId"})
@JsonInclude(Include.NON_NULL)
public class AppListItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("publisher")
    protected String publisher;

    @JsonProperty("appStoreUrl")
    protected String appStoreUrl;

    @JsonProperty("appId")
    protected String appId;

    protected AppListItem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appListItem";
    }

    /**
     * <i>“The application name”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The application name”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public AppListItem withName(String name) {
        AppListItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appListItem");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“The publisher of the application”</i>
     * 
     * @return property publisher
     */
    @Property(name="publisher")
    @JsonIgnore
    public Optional<String> getPublisher() {
        return Optional.ofNullable(publisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code publisher} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The publisher of the application”</i>
     * 
     * @param publisher
     *            new value of {@code publisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code publisher} field changed
     */
    public AppListItem withPublisher(String publisher) {
        AppListItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appListItem");
        _x.publisher = publisher;
        return _x;
    }

    /**
     * <i>“The Store URL of the application”</i>
     * 
     * @return property appStoreUrl
     */
    @Property(name="appStoreUrl")
    @JsonIgnore
    public Optional<String> getAppStoreUrl() {
        return Optional.ofNullable(appStoreUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appStoreUrl}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Store URL of the application”</i>
     * 
     * @param appStoreUrl
     *            new value of {@code appStoreUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appStoreUrl} field changed
     */
    public AppListItem withAppStoreUrl(String appStoreUrl) {
        AppListItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appListItem");
        _x.appStoreUrl = appStoreUrl;
        return _x;
    }

    /**
     * <i>“The bundle identifier of the application”</i>
     * 
     * @return property appId
     */
    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The bundle identifier of the application”</i>
     * 
     * @param appId
     *            new value of {@code appId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appId} field changed
     */
    public AppListItem withAppId(String appId) {
        AppListItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appListItem");
        _x.appId = appId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String publisher;
        private String appStoreUrl;
        private String appId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The application name”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“The publisher of the application”</i>
         * 
         * @param publisher
         *            value of {@code publisher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        /**
         * <i>“The Store URL of the application”</i>
         * 
         * @param appStoreUrl
         *            value of {@code appStoreUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appStoreUrl(String appStoreUrl) {
            this.appStoreUrl = appStoreUrl;
            this.changedFields = changedFields.add("appStoreUrl");
            return this;
        }

        /**
         * <i>“The bundle identifier of the application”</i>
         * 
         * @param appId
         *            value of {@code appId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public AppListItem build() {
            AppListItem _x = new AppListItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.appListItem";
            _x.name = name;
            _x.publisher = publisher;
            _x.appStoreUrl = appStoreUrl;
            _x.appId = appId;
            return _x;
        }
    }

    private AppListItem _copy() {
        AppListItem _x = new AppListItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.publisher = publisher;
        _x.appStoreUrl = appStoreUrl;
        _x.appId = appId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppListItem[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("appStoreUrl=");
        b.append(this.appStoreUrl);
        b.append(", ");
        b.append("appId=");
        b.append(this.appId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
