package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "appId", 
    "displayName", 
    "servicePrincipalId", 
    "servicePrincipalName"})
@JsonInclude(Include.NON_NULL)
public class AppIdentity implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("appId")
    protected String appId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("servicePrincipalId")
    protected String servicePrincipalId;

    @JsonProperty("servicePrincipalName")
    protected String servicePrincipalName;

    protected AppIdentity() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appIdentity";
    }

    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    public AppIdentity withAppId(String appId) {
        AppIdentity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appIdentity");
        _x.appId = appId;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AppIdentity withDisplayName(String displayName) {
        AppIdentity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appIdentity");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="servicePrincipalId")
    @JsonIgnore
    public Optional<String> getServicePrincipalId() {
        return Optional.ofNullable(servicePrincipalId);
    }

    public AppIdentity withServicePrincipalId(String servicePrincipalId) {
        AppIdentity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appIdentity");
        _x.servicePrincipalId = servicePrincipalId;
        return _x;
    }

    @Property(name="servicePrincipalName")
    @JsonIgnore
    public Optional<String> getServicePrincipalName() {
        return Optional.ofNullable(servicePrincipalName);
    }

    public AppIdentity withServicePrincipalName(String servicePrincipalName) {
        AppIdentity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appIdentity");
        _x.servicePrincipalName = servicePrincipalName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String appId;
        private String displayName;
        private String servicePrincipalId;
        private String servicePrincipalName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder servicePrincipalId(String servicePrincipalId) {
            this.servicePrincipalId = servicePrincipalId;
            this.changedFields = changedFields.add("servicePrincipalId");
            return this;
        }

        public Builder servicePrincipalName(String servicePrincipalName) {
            this.servicePrincipalName = servicePrincipalName;
            this.changedFields = changedFields.add("servicePrincipalName");
            return this;
        }

        public AppIdentity build() {
            AppIdentity _x = new AppIdentity();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.appIdentity";
            _x.appId = appId;
            _x.displayName = displayName;
            _x.servicePrincipalId = servicePrincipalId;
            _x.servicePrincipalName = servicePrincipalName;
            return _x;
        }
    }

    private AppIdentity _copy() {
        AppIdentity _x = new AppIdentity();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.appId = appId;
        _x.displayName = displayName;
        _x.servicePrincipalId = servicePrincipalId;
        _x.servicePrincipalName = servicePrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppIdentity[");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("servicePrincipalId=");
        b.append(this.servicePrincipalId);
        b.append(", ");
        b.append("servicePrincipalName=");
        b.append(this.servicePrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
