package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.MdmAppConfigKeyType;


/**
 * <i>“Contains properties for App configuration setting item.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appConfigKey", 
    "appConfigKeyType", 
    "appConfigKeyValue"})
@JsonInclude(Include.NON_NULL)
public class AppConfigurationSettingItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("appConfigKey")
    protected String appConfigKey;

    @JsonProperty("appConfigKeyType")
    protected MdmAppConfigKeyType appConfigKeyType;

    @JsonProperty("appConfigKeyValue")
    protected String appConfigKeyValue;

    protected AppConfigurationSettingItem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appConfigurationSettingItem";
    }

    /**
     * <i>“app configuration key.”</i>
     * 
     * @return property appConfigKey
     */
    @Property(name="appConfigKey")
    @JsonIgnore
    public Optional<String> getAppConfigKey() {
        return Optional.ofNullable(appConfigKey);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appConfigKey}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“app configuration key.”</i>
     * 
     * @param appConfigKey
     *            new value of {@code appConfigKey} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appConfigKey} field changed
     */
    public AppConfigurationSettingItem withAppConfigKey(String appConfigKey) {
        AppConfigurationSettingItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appConfigurationSettingItem");
        _x.appConfigKey = appConfigKey;
        return _x;
    }

    /**
     * <i>“app configuration key type.”</i>
     * 
     * @return property appConfigKeyType
     */
    @Property(name="appConfigKeyType")
    @JsonIgnore
    public Optional<MdmAppConfigKeyType> getAppConfigKeyType() {
        return Optional.ofNullable(appConfigKeyType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appConfigKeyType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“app configuration key type.”</i>
     * 
     * @param appConfigKeyType
     *            new value of {@code appConfigKeyType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appConfigKeyType} field changed
     */
    public AppConfigurationSettingItem withAppConfigKeyType(MdmAppConfigKeyType appConfigKeyType) {
        AppConfigurationSettingItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appConfigurationSettingItem");
        _x.appConfigKeyType = appConfigKeyType;
        return _x;
    }

    /**
     * <i>“app configuration key value.”</i>
     * 
     * @return property appConfigKeyValue
     */
    @Property(name="appConfigKeyValue")
    @JsonIgnore
    public Optional<String> getAppConfigKeyValue() {
        return Optional.ofNullable(appConfigKeyValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appConfigKeyValue
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“app configuration key value.”</i>
     * 
     * @param appConfigKeyValue
     *            new value of {@code appConfigKeyValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appConfigKeyValue} field changed
     */
    public AppConfigurationSettingItem withAppConfigKeyValue(String appConfigKeyValue) {
        AppConfigurationSettingItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appConfigurationSettingItem");
        _x.appConfigKeyValue = appConfigKeyValue;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String appConfigKey;
        private MdmAppConfigKeyType appConfigKeyType;
        private String appConfigKeyValue;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“app configuration key.”</i>
         * 
         * @param appConfigKey
         *            value of {@code appConfigKey} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appConfigKey(String appConfigKey) {
            this.appConfigKey = appConfigKey;
            this.changedFields = changedFields.add("appConfigKey");
            return this;
        }

        /**
         * <i>“app configuration key type.”</i>
         * 
         * @param appConfigKeyType
         *            value of {@code appConfigKeyType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appConfigKeyType(MdmAppConfigKeyType appConfigKeyType) {
            this.appConfigKeyType = appConfigKeyType;
            this.changedFields = changedFields.add("appConfigKeyType");
            return this;
        }

        /**
         * <i>“app configuration key value.”</i>
         * 
         * @param appConfigKeyValue
         *            value of {@code appConfigKeyValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appConfigKeyValue(String appConfigKeyValue) {
            this.appConfigKeyValue = appConfigKeyValue;
            this.changedFields = changedFields.add("appConfigKeyValue");
            return this;
        }

        public AppConfigurationSettingItem build() {
            AppConfigurationSettingItem _x = new AppConfigurationSettingItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.appConfigurationSettingItem";
            _x.appConfigKey = appConfigKey;
            _x.appConfigKeyType = appConfigKeyType;
            _x.appConfigKeyValue = appConfigKeyValue;
            return _x;
        }
    }

    private AppConfigurationSettingItem _copy() {
        AppConfigurationSettingItem _x = new AppConfigurationSettingItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.appConfigKey = appConfigKey;
        _x.appConfigKeyType = appConfigKeyType;
        _x.appConfigKeyValue = appConfigKeyValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppConfigurationSettingItem[");
        b.append("appConfigKey=");
        b.append(this.appConfigKey);
        b.append(", ");
        b.append("appConfigKeyType=");
        b.append(this.appConfigKeyType);
        b.append(", ");
        b.append("appConfigKeyValue=");
        b.append(this.appConfigKeyValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
