package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "resourceSpecificApplicationPermissions"})
@JsonInclude(Include.NON_NULL)
public class ApiServicePrincipal implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("resourceSpecificApplicationPermissions")
    protected List<ResourceSpecificPermission> resourceSpecificApplicationPermissions;

    @JsonProperty("resourceSpecificApplicationPermissions@nextLink")
    protected String resourceSpecificApplicationPermissionsNextLink;

    protected ApiServicePrincipal() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.apiServicePrincipal";
    }

    @Property(name="resourceSpecificApplicationPermissions")
    @JsonIgnore
    public CollectionPage<ResourceSpecificPermission> getResourceSpecificApplicationPermissions() {
        return new CollectionPage<ResourceSpecificPermission>(contextPath, ResourceSpecificPermission.class, resourceSpecificApplicationPermissions, Optional.ofNullable(resourceSpecificApplicationPermissionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="resourceSpecificApplicationPermissions")
    @JsonIgnore
    public CollectionPage<ResourceSpecificPermission> getResourceSpecificApplicationPermissions(HttpRequestOptions options) {
        return new CollectionPage<ResourceSpecificPermission>(contextPath, ResourceSpecificPermission.class, resourceSpecificApplicationPermissions, Optional.ofNullable(resourceSpecificApplicationPermissionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ResourceSpecificPermission> resourceSpecificApplicationPermissions;
        private String resourceSpecificApplicationPermissionsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder resourceSpecificApplicationPermissions(List<ResourceSpecificPermission> resourceSpecificApplicationPermissions) {
            this.resourceSpecificApplicationPermissions = resourceSpecificApplicationPermissions;
            this.changedFields = changedFields.add("resourceSpecificApplicationPermissions");
            return this;
        }

        public Builder resourceSpecificApplicationPermissions(ResourceSpecificPermission... resourceSpecificApplicationPermissions) {
            return resourceSpecificApplicationPermissions(Arrays.asList(resourceSpecificApplicationPermissions));
        }

        public Builder resourceSpecificApplicationPermissionsNextLink(String resourceSpecificApplicationPermissionsNextLink) {
            this.resourceSpecificApplicationPermissionsNextLink = resourceSpecificApplicationPermissionsNextLink;
            this.changedFields = changedFields.add("resourceSpecificApplicationPermissions");
            return this;
        }

        public ApiServicePrincipal build() {
            ApiServicePrincipal _x = new ApiServicePrincipal();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.apiServicePrincipal";
            _x.resourceSpecificApplicationPermissions = resourceSpecificApplicationPermissions;
            _x.resourceSpecificApplicationPermissionsNextLink = resourceSpecificApplicationPermissionsNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ApiServicePrincipal[");
        b.append("resourceSpecificApplicationPermissions=");
        b.append(this.resourceSpecificApplicationPermissions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
