package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.AndroidPermissionActionType;


/**
 * <i>“Mapping between an Android app permission and the action Android should take
 * when that permission is requested.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "permission", 
    "action"})
@JsonInclude(Include.NON_NULL)
public class AndroidPermissionAction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("permission")
    protected String permission;

    @JsonProperty("action")
    protected AndroidPermissionActionType action;

    protected AndroidPermissionAction() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidPermissionAction";
    }

    /**
     * <i>“Android permission string, defined in the official Android documentation.
     * Example 'android.permission.READ_CONTACTS'.”</i>
     * 
     * @return property permission
     */
    @Property(name="permission")
    @JsonIgnore
    public Optional<String> getPermission() {
        return Optional.ofNullable(permission);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code permission} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Android permission string, defined in the official Android documentation.
     * Example 'android.permission.READ_CONTACTS'.”</i>
     * 
     * @param permission
     *            new value of {@code permission} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code permission} field changed
     */
    public AndroidPermissionAction withPermission(String permission) {
        AndroidPermissionAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidPermissionAction");
        _x.permission = permission;
        return _x;
    }

    /**
     * <i>“Type of Android permission action.”</i>
     * 
     * @return property action
     */
    @Property(name="action")
    @JsonIgnore
    public Optional<AndroidPermissionActionType> getAction() {
        return Optional.ofNullable(action);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code action} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Type of Android permission action.”</i>
     * 
     * @param action
     *            new value of {@code action} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code action} field changed
     */
    public AndroidPermissionAction withAction(AndroidPermissionActionType action) {
        AndroidPermissionAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidPermissionAction");
        _x.action = action;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String permission;
        private AndroidPermissionActionType action;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Android permission string, defined in the official Android documentation.
         * Example 'android.permission.READ_CONTACTS'.”</i>
         * 
         * @param permission
         *            value of {@code permission} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder permission(String permission) {
            this.permission = permission;
            this.changedFields = changedFields.add("permission");
            return this;
        }

        /**
         * <i>“Type of Android permission action.”</i>
         * 
         * @param action
         *            value of {@code action} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder action(AndroidPermissionActionType action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        public AndroidPermissionAction build() {
            AndroidPermissionAction _x = new AndroidPermissionAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidPermissionAction";
            _x.permission = permission;
            _x.action = action;
            return _x;
        }
    }

    private AndroidPermissionAction _copy() {
        AndroidPermissionAction _x = new AndroidPermissionAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.permission = permission;
        _x.action = action;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidPermissionAction[");
        b.append("permission=");
        b.append(this.permission);
        b.append(", ");
        b.append("action=");
        b.append(this.action);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
