package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Contains properties for the minimum operating system required for an Android
 * mobile app.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "v4_0", 
    "v4_0_3", 
    "v4_1", 
    "v4_2", 
    "v4_3", 
    "v4_4", 
    "v5_0", 
    "v5_1", 
    "v6_0", 
    "v7_0", 
    "v7_1", 
    "v8_0", 
    "v8_1", 
    "v9_0"})
@JsonInclude(Include.NON_NULL)
public class AndroidMinimumOperatingSystem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("v4_0")
    protected Boolean v4_0;

    @JsonProperty("v4_0_3")
    protected Boolean v4_0_3;

    @JsonProperty("v4_1")
    protected Boolean v4_1;

    @JsonProperty("v4_2")
    protected Boolean v4_2;

    @JsonProperty("v4_3")
    protected Boolean v4_3;

    @JsonProperty("v4_4")
    protected Boolean v4_4;

    @JsonProperty("v5_0")
    protected Boolean v5_0;

    @JsonProperty("v5_1")
    protected Boolean v5_1;

    @JsonProperty("v6_0")
    protected Boolean v6_0;

    @JsonProperty("v7_0")
    protected Boolean v7_0;

    @JsonProperty("v7_1")
    protected Boolean v7_1;

    @JsonProperty("v8_0")
    protected Boolean v8_0;

    @JsonProperty("v8_1")
    protected Boolean v8_1;

    @JsonProperty("v9_0")
    protected Boolean v9_0;

    protected AndroidMinimumOperatingSystem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidMinimumOperatingSystem";
    }

    /**
     * <i>“Version 4.0 or later.”</i>
     * 
     * @return property v4_0
     */
    @Property(name="v4_0")
    @JsonIgnore
    public Optional<Boolean> getV4_0() {
        return Optional.ofNullable(v4_0);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v4_0} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 4.0 or later.”</i>
     * 
     * @param v4_0
     *            new value of {@code v4_0} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v4_0} field changed
     */
    public AndroidMinimumOperatingSystem withV4_0(Boolean v4_0) {
        AndroidMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidMinimumOperatingSystem");
        _x.v4_0 = v4_0;
        return _x;
    }

    /**
     * <i>“Version 4.0.3 or later.”</i>
     * 
     * @return property v4_0_3
     */
    @Property(name="v4_0_3")
    @JsonIgnore
    public Optional<Boolean> getV4_0_3() {
        return Optional.ofNullable(v4_0_3);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v4_0_3} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 4.0.3 or later.”</i>
     * 
     * @param v4_0_3
     *            new value of {@code v4_0_3} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v4_0_3} field changed
     */
    public AndroidMinimumOperatingSystem withV4_0_3(Boolean v4_0_3) {
        AndroidMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidMinimumOperatingSystem");
        _x.v4_0_3 = v4_0_3;
        return _x;
    }

    /**
     * <i>“Version 4.1 or later.”</i>
     * 
     * @return property v4_1
     */
    @Property(name="v4_1")
    @JsonIgnore
    public Optional<Boolean> getV4_1() {
        return Optional.ofNullable(v4_1);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v4_1} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 4.1 or later.”</i>
     * 
     * @param v4_1
     *            new value of {@code v4_1} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v4_1} field changed
     */
    public AndroidMinimumOperatingSystem withV4_1(Boolean v4_1) {
        AndroidMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidMinimumOperatingSystem");
        _x.v4_1 = v4_1;
        return _x;
    }

    /**
     * <i>“Version 4.2 or later.”</i>
     * 
     * @return property v4_2
     */
    @Property(name="v4_2")
    @JsonIgnore
    public Optional<Boolean> getV4_2() {
        return Optional.ofNullable(v4_2);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v4_2} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 4.2 or later.”</i>
     * 
     * @param v4_2
     *            new value of {@code v4_2} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v4_2} field changed
     */
    public AndroidMinimumOperatingSystem withV4_2(Boolean v4_2) {
        AndroidMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidMinimumOperatingSystem");
        _x.v4_2 = v4_2;
        return _x;
    }

    /**
     * <i>“Version 4.3 or later.”</i>
     * 
     * @return property v4_3
     */
    @Property(name="v4_3")
    @JsonIgnore
    public Optional<Boolean> getV4_3() {
        return Optional.ofNullable(v4_3);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v4_3} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 4.3 or later.”</i>
     * 
     * @param v4_3
     *            new value of {@code v4_3} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v4_3} field changed
     */
    public AndroidMinimumOperatingSystem withV4_3(Boolean v4_3) {
        AndroidMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidMinimumOperatingSystem");
        _x.v4_3 = v4_3;
        return _x;
    }

    /**
     * <i>“Version 4.4 or later.”</i>
     * 
     * @return property v4_4
     */
    @Property(name="v4_4")
    @JsonIgnore
    public Optional<Boolean> getV4_4() {
        return Optional.ofNullable(v4_4);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v4_4} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 4.4 or later.”</i>
     * 
     * @param v4_4
     *            new value of {@code v4_4} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v4_4} field changed
     */
    public AndroidMinimumOperatingSystem withV4_4(Boolean v4_4) {
        AndroidMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidMinimumOperatingSystem");
        _x.v4_4 = v4_4;
        return _x;
    }

    /**
     * <i>“Version 5.0 or later.”</i>
     * 
     * @return property v5_0
     */
    @Property(name="v5_0")
    @JsonIgnore
    public Optional<Boolean> getV5_0() {
        return Optional.ofNullable(v5_0);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v5_0} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 5.0 or later.”</i>
     * 
     * @param v5_0
     *            new value of {@code v5_0} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v5_0} field changed
     */
    public AndroidMinimumOperatingSystem withV5_0(Boolean v5_0) {
        AndroidMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidMinimumOperatingSystem");
        _x.v5_0 = v5_0;
        return _x;
    }

    /**
     * <i>“Version 5.1 or later.”</i>
     * 
     * @return property v5_1
     */
    @Property(name="v5_1")
    @JsonIgnore
    public Optional<Boolean> getV5_1() {
        return Optional.ofNullable(v5_1);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v5_1} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 5.1 or later.”</i>
     * 
     * @param v5_1
     *            new value of {@code v5_1} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v5_1} field changed
     */
    public AndroidMinimumOperatingSystem withV5_1(Boolean v5_1) {
        AndroidMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidMinimumOperatingSystem");
        _x.v5_1 = v5_1;
        return _x;
    }

    /**
     * <i>“Version 6.0 or later.”</i>
     * 
     * @return property v6_0
     */
    @Property(name="v6_0")
    @JsonIgnore
    public Optional<Boolean> getV6_0() {
        return Optional.ofNullable(v6_0);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v6_0} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 6.0 or later.”</i>
     * 
     * @param v6_0
     *            new value of {@code v6_0} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v6_0} field changed
     */
    public AndroidMinimumOperatingSystem withV6_0(Boolean v6_0) {
        AndroidMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidMinimumOperatingSystem");
        _x.v6_0 = v6_0;
        return _x;
    }

    /**
     * <i>“Version 7.0 or later.”</i>
     * 
     * @return property v7_0
     */
    @Property(name="v7_0")
    @JsonIgnore
    public Optional<Boolean> getV7_0() {
        return Optional.ofNullable(v7_0);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v7_0} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 7.0 or later.”</i>
     * 
     * @param v7_0
     *            new value of {@code v7_0} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v7_0} field changed
     */
    public AndroidMinimumOperatingSystem withV7_0(Boolean v7_0) {
        AndroidMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidMinimumOperatingSystem");
        _x.v7_0 = v7_0;
        return _x;
    }

    /**
     * <i>“Version 7.1 or later.”</i>
     * 
     * @return property v7_1
     */
    @Property(name="v7_1")
    @JsonIgnore
    public Optional<Boolean> getV7_1() {
        return Optional.ofNullable(v7_1);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v7_1} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 7.1 or later.”</i>
     * 
     * @param v7_1
     *            new value of {@code v7_1} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v7_1} field changed
     */
    public AndroidMinimumOperatingSystem withV7_1(Boolean v7_1) {
        AndroidMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidMinimumOperatingSystem");
        _x.v7_1 = v7_1;
        return _x;
    }

    /**
     * <i>“Version 8.0 or later.”</i>
     * 
     * @return property v8_0
     */
    @Property(name="v8_0")
    @JsonIgnore
    public Optional<Boolean> getV8_0() {
        return Optional.ofNullable(v8_0);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v8_0} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 8.0 or later.”</i>
     * 
     * @param v8_0
     *            new value of {@code v8_0} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v8_0} field changed
     */
    public AndroidMinimumOperatingSystem withV8_0(Boolean v8_0) {
        AndroidMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidMinimumOperatingSystem");
        _x.v8_0 = v8_0;
        return _x;
    }

    /**
     * <i>“Version 8.1 or later.”</i>
     * 
     * @return property v8_1
     */
    @Property(name="v8_1")
    @JsonIgnore
    public Optional<Boolean> getV8_1() {
        return Optional.ofNullable(v8_1);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v8_1} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 8.1 or later.”</i>
     * 
     * @param v8_1
     *            new value of {@code v8_1} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v8_1} field changed
     */
    public AndroidMinimumOperatingSystem withV8_1(Boolean v8_1) {
        AndroidMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidMinimumOperatingSystem");
        _x.v8_1 = v8_1;
        return _x;
    }

    /**
     * <i>“Version 9.0 or later.”</i>
     * 
     * @return property v9_0
     */
    @Property(name="v9_0")
    @JsonIgnore
    public Optional<Boolean> getV9_0() {
        return Optional.ofNullable(v9_0);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v9_0} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 9.0 or later.”</i>
     * 
     * @param v9_0
     *            new value of {@code v9_0} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v9_0} field changed
     */
    public AndroidMinimumOperatingSystem withV9_0(Boolean v9_0) {
        AndroidMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidMinimumOperatingSystem");
        _x.v9_0 = v9_0;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean v4_0;
        private Boolean v4_0_3;
        private Boolean v4_1;
        private Boolean v4_2;
        private Boolean v4_3;
        private Boolean v4_4;
        private Boolean v5_0;
        private Boolean v5_1;
        private Boolean v6_0;
        private Boolean v7_0;
        private Boolean v7_1;
        private Boolean v8_0;
        private Boolean v8_1;
        private Boolean v9_0;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Version 4.0 or later.”</i>
         * 
         * @param v4_0
         *            value of {@code v4_0} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v4_0(Boolean v4_0) {
            this.v4_0 = v4_0;
            this.changedFields = changedFields.add("v4_0");
            return this;
        }

        /**
         * <i>“Version 4.0.3 or later.”</i>
         * 
         * @param v4_0_3
         *            value of {@code v4_0_3} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v4_0_3(Boolean v4_0_3) {
            this.v4_0_3 = v4_0_3;
            this.changedFields = changedFields.add("v4_0_3");
            return this;
        }

        /**
         * <i>“Version 4.1 or later.”</i>
         * 
         * @param v4_1
         *            value of {@code v4_1} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v4_1(Boolean v4_1) {
            this.v4_1 = v4_1;
            this.changedFields = changedFields.add("v4_1");
            return this;
        }

        /**
         * <i>“Version 4.2 or later.”</i>
         * 
         * @param v4_2
         *            value of {@code v4_2} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v4_2(Boolean v4_2) {
            this.v4_2 = v4_2;
            this.changedFields = changedFields.add("v4_2");
            return this;
        }

        /**
         * <i>“Version 4.3 or later.”</i>
         * 
         * @param v4_3
         *            value of {@code v4_3} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v4_3(Boolean v4_3) {
            this.v4_3 = v4_3;
            this.changedFields = changedFields.add("v4_3");
            return this;
        }

        /**
         * <i>“Version 4.4 or later.”</i>
         * 
         * @param v4_4
         *            value of {@code v4_4} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v4_4(Boolean v4_4) {
            this.v4_4 = v4_4;
            this.changedFields = changedFields.add("v4_4");
            return this;
        }

        /**
         * <i>“Version 5.0 or later.”</i>
         * 
         * @param v5_0
         *            value of {@code v5_0} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v5_0(Boolean v5_0) {
            this.v5_0 = v5_0;
            this.changedFields = changedFields.add("v5_0");
            return this;
        }

        /**
         * <i>“Version 5.1 or later.”</i>
         * 
         * @param v5_1
         *            value of {@code v5_1} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v5_1(Boolean v5_1) {
            this.v5_1 = v5_1;
            this.changedFields = changedFields.add("v5_1");
            return this;
        }

        /**
         * <i>“Version 6.0 or later.”</i>
         * 
         * @param v6_0
         *            value of {@code v6_0} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v6_0(Boolean v6_0) {
            this.v6_0 = v6_0;
            this.changedFields = changedFields.add("v6_0");
            return this;
        }

        /**
         * <i>“Version 7.0 or later.”</i>
         * 
         * @param v7_0
         *            value of {@code v7_0} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v7_0(Boolean v7_0) {
            this.v7_0 = v7_0;
            this.changedFields = changedFields.add("v7_0");
            return this;
        }

        /**
         * <i>“Version 7.1 or later.”</i>
         * 
         * @param v7_1
         *            value of {@code v7_1} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v7_1(Boolean v7_1) {
            this.v7_1 = v7_1;
            this.changedFields = changedFields.add("v7_1");
            return this;
        }

        /**
         * <i>“Version 8.0 or later.”</i>
         * 
         * @param v8_0
         *            value of {@code v8_0} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v8_0(Boolean v8_0) {
            this.v8_0 = v8_0;
            this.changedFields = changedFields.add("v8_0");
            return this;
        }

        /**
         * <i>“Version 8.1 or later.”</i>
         * 
         * @param v8_1
         *            value of {@code v8_1} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v8_1(Boolean v8_1) {
            this.v8_1 = v8_1;
            this.changedFields = changedFields.add("v8_1");
            return this;
        }

        /**
         * <i>“Version 9.0 or later.”</i>
         * 
         * @param v9_0
         *            value of {@code v9_0} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v9_0(Boolean v9_0) {
            this.v9_0 = v9_0;
            this.changedFields = changedFields.add("v9_0");
            return this;
        }

        public AndroidMinimumOperatingSystem build() {
            AndroidMinimumOperatingSystem _x = new AndroidMinimumOperatingSystem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidMinimumOperatingSystem";
            _x.v4_0 = v4_0;
            _x.v4_0_3 = v4_0_3;
            _x.v4_1 = v4_1;
            _x.v4_2 = v4_2;
            _x.v4_3 = v4_3;
            _x.v4_4 = v4_4;
            _x.v5_0 = v5_0;
            _x.v5_1 = v5_1;
            _x.v6_0 = v6_0;
            _x.v7_0 = v7_0;
            _x.v7_1 = v7_1;
            _x.v8_0 = v8_0;
            _x.v8_1 = v8_1;
            _x.v9_0 = v9_0;
            return _x;
        }
    }

    private AndroidMinimumOperatingSystem _copy() {
        AndroidMinimumOperatingSystem _x = new AndroidMinimumOperatingSystem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.v4_0 = v4_0;
        _x.v4_0_3 = v4_0_3;
        _x.v4_1 = v4_1;
        _x.v4_2 = v4_2;
        _x.v4_3 = v4_3;
        _x.v4_4 = v4_4;
        _x.v5_0 = v5_0;
        _x.v5_1 = v5_1;
        _x.v6_0 = v6_0;
        _x.v7_0 = v7_0;
        _x.v7_1 = v7_1;
        _x.v8_0 = v8_0;
        _x.v8_1 = v8_1;
        _x.v9_0 = v9_0;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidMinimumOperatingSystem[");
        b.append("v4_0=");
        b.append(this.v4_0);
        b.append(", ");
        b.append("v4_0_3=");
        b.append(this.v4_0_3);
        b.append(", ");
        b.append("v4_1=");
        b.append(this.v4_1);
        b.append(", ");
        b.append("v4_2=");
        b.append(this.v4_2);
        b.append(", ");
        b.append("v4_3=");
        b.append(this.v4_3);
        b.append(", ");
        b.append("v4_4=");
        b.append(this.v4_4);
        b.append(", ");
        b.append("v5_0=");
        b.append(this.v5_0);
        b.append(", ");
        b.append("v5_1=");
        b.append(this.v5_1);
        b.append(", ");
        b.append("v6_0=");
        b.append(this.v6_0);
        b.append(", ");
        b.append("v7_0=");
        b.append(this.v7_0);
        b.append(", ");
        b.append("v7_1=");
        b.append(this.v7_1);
        b.append(", ");
        b.append("v8_0=");
        b.append(this.v8_0);
        b.append(", ");
        b.append("v8_1=");
        b.append(this.v8_1);
        b.append(", ");
        b.append("v9_0=");
        b.append(this.v9_0);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
