package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Contains track information for Android Managed Store apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "trackId", 
    "trackAlias"})
@JsonInclude(Include.NON_NULL)
public class AndroidManagedStoreAppTrack implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("trackId")
    protected String trackId;

    @JsonProperty("trackAlias")
    protected String trackAlias;

    protected AndroidManagedStoreAppTrack() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidManagedStoreAppTrack";
    }

    /**
     * <i>“Unique track identifier.”</i>
     * 
     * @return property trackId
     */
    @Property(name="trackId")
    @JsonIgnore
    public Optional<String> getTrackId() {
        return Optional.ofNullable(trackId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code trackId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Unique track identifier.”</i>
     * 
     * @param trackId
     *            new value of {@code trackId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code trackId} field changed
     */
    public AndroidManagedStoreAppTrack withTrackId(String trackId) {
        AndroidManagedStoreAppTrack _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreAppTrack");
        _x.trackId = trackId;
        return _x;
    }

    /**
     * <i>“Friendly name for track.”</i>
     * 
     * @return property trackAlias
     */
    @Property(name="trackAlias")
    @JsonIgnore
    public Optional<String> getTrackAlias() {
        return Optional.ofNullable(trackAlias);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code trackAlias} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Friendly name for track.”</i>
     * 
     * @param trackAlias
     *            new value of {@code trackAlias} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code trackAlias} field changed
     */
    public AndroidManagedStoreAppTrack withTrackAlias(String trackAlias) {
        AndroidManagedStoreAppTrack _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreAppTrack");
        _x.trackAlias = trackAlias;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String trackId;
        private String trackAlias;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Unique track identifier.”</i>
         * 
         * @param trackId
         *            value of {@code trackId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trackId(String trackId) {
            this.trackId = trackId;
            this.changedFields = changedFields.add("trackId");
            return this;
        }

        /**
         * <i>“Friendly name for track.”</i>
         * 
         * @param trackAlias
         *            value of {@code trackAlias} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trackAlias(String trackAlias) {
            this.trackAlias = trackAlias;
            this.changedFields = changedFields.add("trackAlias");
            return this;
        }

        public AndroidManagedStoreAppTrack build() {
            AndroidManagedStoreAppTrack _x = new AndroidManagedStoreAppTrack();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidManagedStoreAppTrack";
            _x.trackId = trackId;
            _x.trackAlias = trackAlias;
            return _x;
        }
    }

    private AndroidManagedStoreAppTrack _copy() {
        AndroidManagedStoreAppTrack _x = new AndroidManagedStoreAppTrack();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.trackId = trackId;
        _x.trackAlias = trackAlias;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidManagedStoreAppTrack[");
        b.append("trackId=");
        b.append(this.trackId);
        b.append(", ");
        b.append("trackAlias=");
        b.append(this.trackAlias);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
