package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Contains properties used to assign an Android Managed Store mobile app to a
 * group.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "androidManagedStoreAppTrackIds"})
@JsonInclude(Include.NON_NULL)
public class AndroidManagedStoreAppAssignmentSettings extends MobileAppAssignmentSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("androidManagedStoreAppTrackIds")
    protected List<String> androidManagedStoreAppTrackIds;

    @JsonProperty("androidManagedStoreAppTrackIds@nextLink")
    protected String androidManagedStoreAppTrackIdsNextLink;

    protected AndroidManagedStoreAppAssignmentSettings() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidManagedStoreAppAssignmentSettings";
    }

    /**
     * <i>“The track IDs to enable for this app assignment.”</i>
     * 
     * @return property androidManagedStoreAppTrackIds
     */
    @Property(name="androidManagedStoreAppTrackIds")
    @JsonIgnore
    public CollectionPage<String> getAndroidManagedStoreAppTrackIds() {
        return new CollectionPage<String>(contextPath, String.class, androidManagedStoreAppTrackIds, Optional.ofNullable(androidManagedStoreAppTrackIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The track IDs to enable for this app assignment.”</i>
     * 
     * @return property androidManagedStoreAppTrackIds
     */
    @Property(name="androidManagedStoreAppTrackIds")
    @JsonIgnore
    public CollectionPage<String> getAndroidManagedStoreAppTrackIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, androidManagedStoreAppTrackIds, Optional.ofNullable(androidManagedStoreAppTrackIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidManagedStoreAppAssignmentSettings() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> androidManagedStoreAppTrackIds;
        private String androidManagedStoreAppTrackIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The track IDs to enable for this app assignment.”</i>
         * 
         * @param androidManagedStoreAppTrackIds
         *            value of {@code androidManagedStoreAppTrackIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidManagedStoreAppTrackIds(List<String> androidManagedStoreAppTrackIds) {
            this.androidManagedStoreAppTrackIds = androidManagedStoreAppTrackIds;
            this.changedFields = changedFields.add("androidManagedStoreAppTrackIds");
            return this;
        }

        /**
         * <i>“The track IDs to enable for this app assignment.”</i>
         * 
         * @param androidManagedStoreAppTrackIds
         *            value of {@code androidManagedStoreAppTrackIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidManagedStoreAppTrackIds(String... androidManagedStoreAppTrackIds) {
            return androidManagedStoreAppTrackIds(Arrays.asList(androidManagedStoreAppTrackIds));
        }

        /**
         * <i>“The track IDs to enable for this app assignment.”</i>
         * 
         * @param androidManagedStoreAppTrackIdsNextLink
         *            value of {@code androidManagedStoreAppTrackIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidManagedStoreAppTrackIdsNextLink(String androidManagedStoreAppTrackIdsNextLink) {
            this.androidManagedStoreAppTrackIdsNextLink = androidManagedStoreAppTrackIdsNextLink;
            this.changedFields = changedFields.add("androidManagedStoreAppTrackIds");
            return this;
        }

        public AndroidManagedStoreAppAssignmentSettings build() {
            AndroidManagedStoreAppAssignmentSettings _x = new AndroidManagedStoreAppAssignmentSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidManagedStoreAppAssignmentSettings";
            _x.androidManagedStoreAppTrackIds = androidManagedStoreAppTrackIds;
            _x.androidManagedStoreAppTrackIdsNextLink = androidManagedStoreAppTrackIdsNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidManagedStoreAppAssignmentSettings[");
        b.append("androidManagedStoreAppTrackIds=");
        b.append(this.androidManagedStoreAppTrackIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
