package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import odata.msgraph.client.beta.enums.DeviceAndAppManagementAssignmentFilterType;


/**
 * <i>“Represents an assignment to all managed devices in the tenant.”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class AllDevicesAssignmentTarget extends DeviceAndAppManagementAssignmentTarget implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    protected AllDevicesAssignmentTarget() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.allDevicesAssignmentTarget";
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAllDevicesAssignmentTarget() {
        return new Builder();
    }

    public static final class Builder {
        private String deviceAndAppManagementAssignmentFilterId;
        private DeviceAndAppManagementAssignmentFilterType deviceAndAppManagementAssignmentFilterType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder deviceAndAppManagementAssignmentFilterId(String deviceAndAppManagementAssignmentFilterId) {
            this.deviceAndAppManagementAssignmentFilterId = deviceAndAppManagementAssignmentFilterId;
            this.changedFields = changedFields.add("deviceAndAppManagementAssignmentFilterId");
            return this;
        }

        public Builder deviceAndAppManagementAssignmentFilterType(DeviceAndAppManagementAssignmentFilterType deviceAndAppManagementAssignmentFilterType) {
            this.deviceAndAppManagementAssignmentFilterType = deviceAndAppManagementAssignmentFilterType;
            this.changedFields = changedFields.add("deviceAndAppManagementAssignmentFilterType");
            return this;
        }

        public AllDevicesAssignmentTarget build() {
            AllDevicesAssignmentTarget _x = new AllDevicesAssignmentTarget();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.allDevicesAssignmentTarget";
            _x.deviceAndAppManagementAssignmentFilterId = deviceAndAppManagementAssignmentFilterId;
            _x.deviceAndAppManagementAssignmentFilterType = deviceAndAppManagementAssignmentFilterType;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AllDevicesAssignmentTarget[");
        b.append("deviceAndAppManagementAssignmentFilterId=");
        b.append(this.deviceAndAppManagementAssignmentFilterId);
        b.append(", ");
        b.append("deviceAndAppManagementAssignmentFilterType=");
        b.append(this.deviceAndAppManagementAssignmentFilterType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
