package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AlertFeedback;
import odata.msgraph.client.beta.enums.AlertStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "appId", 
    "assignedTo", 
    "comments", 
    "feedback", 
    "status", 
    "updatedDateTime", 
    "user"})
@JsonInclude(Include.NON_NULL)
public class AlertHistoryState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("appId")
    protected String appId;

    @JsonProperty("assignedTo")
    protected String assignedTo;

    @JsonProperty("comments")
    protected List<String> comments;

    @JsonProperty("comments@nextLink")
    protected String commentsNextLink;

    @JsonProperty("feedback")
    protected AlertFeedback feedback;

    @JsonProperty("status")
    protected AlertStatus status;

    @JsonProperty("updatedDateTime")
    protected OffsetDateTime updatedDateTime;

    @JsonProperty("user")
    protected String user;

    protected AlertHistoryState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.alertHistoryState";
    }

    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    public AlertHistoryState withAppId(String appId) {
        AlertHistoryState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alertHistoryState");
        _x.appId = appId;
        return _x;
    }

    @Property(name="assignedTo")
    @JsonIgnore
    public Optional<String> getAssignedTo() {
        return Optional.ofNullable(assignedTo);
    }

    public AlertHistoryState withAssignedTo(String assignedTo) {
        AlertHistoryState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alertHistoryState");
        _x.assignedTo = assignedTo;
        return _x;
    }

    @Property(name="comments")
    @JsonIgnore
    public CollectionPage<String> getComments() {
        return new CollectionPage<String>(contextPath, String.class, comments, Optional.ofNullable(commentsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="comments")
    @JsonIgnore
    public CollectionPage<String> getComments(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, comments, Optional.ofNullable(commentsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="feedback")
    @JsonIgnore
    public Optional<AlertFeedback> getFeedback() {
        return Optional.ofNullable(feedback);
    }

    public AlertHistoryState withFeedback(AlertFeedback feedback) {
        AlertHistoryState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alertHistoryState");
        _x.feedback = feedback;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<AlertStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public AlertHistoryState withStatus(AlertStatus status) {
        AlertHistoryState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alertHistoryState");
        _x.status = status;
        return _x;
    }

    @Property(name="updatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getUpdatedDateTime() {
        return Optional.ofNullable(updatedDateTime);
    }

    public AlertHistoryState withUpdatedDateTime(OffsetDateTime updatedDateTime) {
        AlertHistoryState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alertHistoryState");
        _x.updatedDateTime = updatedDateTime;
        return _x;
    }

    @Property(name="user")
    @JsonIgnore
    public Optional<String> getUser() {
        return Optional.ofNullable(user);
    }

    public AlertHistoryState withUser(String user) {
        AlertHistoryState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alertHistoryState");
        _x.user = user;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String appId;
        private String assignedTo;
        private List<String> comments;
        private String commentsNextLink;
        private AlertFeedback feedback;
        private AlertStatus status;
        private OffsetDateTime updatedDateTime;
        private String user;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public Builder assignedTo(String assignedTo) {
            this.assignedTo = assignedTo;
            this.changedFields = changedFields.add("assignedTo");
            return this;
        }

        public Builder comments(List<String> comments) {
            this.comments = comments;
            this.changedFields = changedFields.add("comments");
            return this;
        }

        public Builder comments(String... comments) {
            return comments(Arrays.asList(comments));
        }

        public Builder commentsNextLink(String commentsNextLink) {
            this.commentsNextLink = commentsNextLink;
            this.changedFields = changedFields.add("comments");
            return this;
        }

        public Builder feedback(AlertFeedback feedback) {
            this.feedback = feedback;
            this.changedFields = changedFields.add("feedback");
            return this;
        }

        public Builder status(AlertStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder updatedDateTime(OffsetDateTime updatedDateTime) {
            this.updatedDateTime = updatedDateTime;
            this.changedFields = changedFields.add("updatedDateTime");
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            this.changedFields = changedFields.add("user");
            return this;
        }

        public AlertHistoryState build() {
            AlertHistoryState _x = new AlertHistoryState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.alertHistoryState";
            _x.appId = appId;
            _x.assignedTo = assignedTo;
            _x.comments = comments;
            _x.commentsNextLink = commentsNextLink;
            _x.feedback = feedback;
            _x.status = status;
            _x.updatedDateTime = updatedDateTime;
            _x.user = user;
            return _x;
        }
    }

    private AlertHistoryState _copy() {
        AlertHistoryState _x = new AlertHistoryState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.appId = appId;
        _x.assignedTo = assignedTo;
        _x.comments = comments;
        _x.feedback = feedback;
        _x.status = status;
        _x.updatedDateTime = updatedDateTime;
        _x.user = user;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AlertHistoryState[");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("assignedTo=");
        b.append(this.assignedTo);
        b.append(", ");
        b.append("comments=");
        b.append(this.comments);
        b.append(", ");
        b.append("feedback=");
        b.append(this.feedback);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("updatedDateTime=");
        b.append(this.updatedDateTime);
        b.append(", ");
        b.append("user=");
        b.append(this.user);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
