package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Represents an AirPrint destination.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "ipAddress", 
    "resourcePath", 
    "port", 
    "forceTls"})
@JsonInclude(Include.NON_NULL)
public class AirPrintDestination implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ipAddress")
    protected String ipAddress;

    @JsonProperty("resourcePath")
    protected String resourcePath;

    @JsonProperty("port")
    protected Integer port;

    @JsonProperty("forceTls")
    protected Boolean forceTls;

    protected AirPrintDestination() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.airPrintDestination";
    }

    /**
     * <i>“The IP Address of the AirPrint destination.”</i>
     * 
     * @return property ipAddress
     */
    @Property(name="ipAddress")
    @JsonIgnore
    public Optional<String> getIpAddress() {
        return Optional.ofNullable(ipAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ipAddress} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The IP Address of the AirPrint destination.”</i>
     * 
     * @param ipAddress
     *            new value of {@code ipAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ipAddress} field changed
     */
    public AirPrintDestination withIpAddress(String ipAddress) {
        AirPrintDestination _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.airPrintDestination");
        _x.ipAddress = ipAddress;
        return _x;
    }

    /**
     * <i>“The Resource Path associated with the printer. This corresponds to the rp
     * parameter of the _ipps.tcp Bonjour record. For example: printers/Canon_MG5300_
     * series, printers/Xerox_Phaser_7600, ipp/print, Epson_IPP_Printer.”</i>
     * 
     * @return property resourcePath
     */
    @Property(name="resourcePath")
    @JsonIgnore
    public Optional<String> getResourcePath() {
        return Optional.ofNullable(resourcePath);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code resourcePath}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Resource Path associated with the printer. This corresponds to the rp
     * parameter of the _ipps.tcp Bonjour record. For example: printers/Canon_MG5300_
     * series, printers/Xerox_Phaser_7600, ipp/print, Epson_IPP_Printer.”</i>
     * 
     * @param resourcePath
     *            new value of {@code resourcePath} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resourcePath} field changed
     */
    public AirPrintDestination withResourcePath(String resourcePath) {
        AirPrintDestination _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.airPrintDestination");
        _x.resourcePath = resourcePath;
        return _x;
    }

    /**
     * <i>“The listening port of the AirPrint destination. If this key is not specified
     * AirPrint will use the default port. Available in iOS 11.0 and later.”</i>
     * 
     * @return property port
     */
    @Property(name="port")
    @JsonIgnore
    public Optional<Integer> getPort() {
        return Optional.ofNullable(port);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code port} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The listening port of the AirPrint destination. If this key is not specified
     * AirPrint will use the default port. Available in iOS 11.0 and later.”</i>
     * 
     * @param port
     *            new value of {@code port} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code port} field changed
     */
    public AirPrintDestination withPort(Integer port) {
        AirPrintDestination _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.airPrintDestination");
        _x.port = port;
        return _x;
    }

    /**
     * <i>“If true AirPrint connections are secured by Transport Layer Security (TLS).
     * Default is false. Available in iOS 11.0 and later.”</i>
     * 
     * @return property forceTls
     */
    @Property(name="forceTls")
    @JsonIgnore
    public Optional<Boolean> getForceTls() {
        return Optional.ofNullable(forceTls);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code forceTls} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“If true AirPrint connections are secured by Transport Layer Security (TLS).
     * Default is false. Available in iOS 11.0 and later.”</i>
     * 
     * @param forceTls
     *            new value of {@code forceTls} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code forceTls} field changed
     */
    public AirPrintDestination withForceTls(Boolean forceTls) {
        AirPrintDestination _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.airPrintDestination");
        _x.forceTls = forceTls;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String ipAddress;
        private String resourcePath;
        private Integer port;
        private Boolean forceTls;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The IP Address of the AirPrint destination.”</i>
         * 
         * @param ipAddress
         *            value of {@code ipAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.changedFields = changedFields.add("ipAddress");
            return this;
        }

        /**
         * <i>“The Resource Path associated with the printer. This corresponds to the rp
         * parameter of the _ipps.tcp Bonjour record. For example: printers/Canon_MG5300_
         * series, printers/Xerox_Phaser_7600, ipp/print, Epson_IPP_Printer.”</i>
         * 
         * @param resourcePath
         *            value of {@code resourcePath} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            this.changedFields = changedFields.add("resourcePath");
            return this;
        }

        /**
         * <i>“The listening port of the AirPrint destination. If this key is not specified
         * AirPrint will use the default port. Available in iOS 11.0 and later.”</i>
         * 
         * @param port
         *            value of {@code port} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder port(Integer port) {
            this.port = port;
            this.changedFields = changedFields.add("port");
            return this;
        }

        /**
         * <i>“If true AirPrint connections are secured by Transport Layer Security (TLS).
         * Default is false. Available in iOS 11.0 and later.”</i>
         * 
         * @param forceTls
         *            value of {@code forceTls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder forceTls(Boolean forceTls) {
            this.forceTls = forceTls;
            this.changedFields = changedFields.add("forceTls");
            return this;
        }

        public AirPrintDestination build() {
            AirPrintDestination _x = new AirPrintDestination();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.airPrintDestination";
            _x.ipAddress = ipAddress;
            _x.resourcePath = resourcePath;
            _x.port = port;
            _x.forceTls = forceTls;
            return _x;
        }
    }

    private AirPrintDestination _copy() {
        AirPrintDestination _x = new AirPrintDestination();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.ipAddress = ipAddress;
        _x.resourcePath = resourcePath;
        _x.port = port;
        _x.forceTls = forceTls;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AirPrintDestination[");
        b.append("ipAddress=");
        b.append(this.ipAddress);
        b.append(", ");
        b.append("resourcePath=");
        b.append(this.resourcePath);
        b.append(", ");
        b.append("port=");
        b.append(this.port);
        b.append(", ");
        b.append("forceTls=");
        b.append(this.forceTls);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
