package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.AdminConsentState;


/**
 * <i>“Admin consent information.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "shareAPNSData", 
    "shareUserExperienceAnalyticsData"})
@JsonInclude(Include.NON_NULL)
public class AdminConsent implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("shareAPNSData")
    protected AdminConsentState shareAPNSData;

    @JsonProperty("shareUserExperienceAnalyticsData")
    protected AdminConsentState shareUserExperienceAnalyticsData;

    protected AdminConsent() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.adminConsent";
    }

    /**
     * <i>“The admin consent state of sharing user and device data to Apple.”</i>
     * 
     * @return property shareAPNSData
     */
    @Property(name="shareAPNSData")
    @JsonIgnore
    public Optional<AdminConsentState> getShareAPNSData() {
        return Optional.ofNullable(shareAPNSData);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code shareAPNSData}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The admin consent state of sharing user and device data to Apple.”</i>
     * 
     * @param shareAPNSData
     *            new value of {@code shareAPNSData} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code shareAPNSData} field changed
     */
    public AdminConsent withShareAPNSData(AdminConsentState shareAPNSData) {
        AdminConsent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.adminConsent");
        _x.shareAPNSData = shareAPNSData;
        return _x;
    }

    /**
     * <i>“Gets or sets the admin consent for sharing User experience analytics data.”</i>
     * 
     * @return property shareUserExperienceAnalyticsData
     */
    @Property(name="shareUserExperienceAnalyticsData")
    @JsonIgnore
    public Optional<AdminConsentState> getShareUserExperienceAnalyticsData() {
        return Optional.ofNullable(shareUserExperienceAnalyticsData);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * shareUserExperienceAnalyticsData} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets the admin consent for sharing User experience analytics data.”</i>
     * 
     * @param shareUserExperienceAnalyticsData
     *            new value of {@code shareUserExperienceAnalyticsData} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code shareUserExperienceAnalyticsData} field changed
     */
    public AdminConsent withShareUserExperienceAnalyticsData(AdminConsentState shareUserExperienceAnalyticsData) {
        AdminConsent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.adminConsent");
        _x.shareUserExperienceAnalyticsData = shareUserExperienceAnalyticsData;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AdminConsentState shareAPNSData;
        private AdminConsentState shareUserExperienceAnalyticsData;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The admin consent state of sharing user and device data to Apple.”</i>
         * 
         * @param shareAPNSData
         *            value of {@code shareAPNSData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder shareAPNSData(AdminConsentState shareAPNSData) {
            this.shareAPNSData = shareAPNSData;
            this.changedFields = changedFields.add("shareAPNSData");
            return this;
        }

        /**
         * <i>“Gets or sets the admin consent for sharing User experience analytics data.”</i>
         * 
         * @param shareUserExperienceAnalyticsData
         *            value of {@code shareUserExperienceAnalyticsData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder shareUserExperienceAnalyticsData(AdminConsentState shareUserExperienceAnalyticsData) {
            this.shareUserExperienceAnalyticsData = shareUserExperienceAnalyticsData;
            this.changedFields = changedFields.add("shareUserExperienceAnalyticsData");
            return this;
        }

        public AdminConsent build() {
            AdminConsent _x = new AdminConsent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.adminConsent";
            _x.shareAPNSData = shareAPNSData;
            _x.shareUserExperienceAnalyticsData = shareUserExperienceAnalyticsData;
            return _x;
        }
    }

    private AdminConsent _copy() {
        AdminConsent _x = new AdminConsent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.shareAPNSData = shareAPNSData;
        _x.shareUserExperienceAnalyticsData = shareUserExperienceAnalyticsData;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AdminConsent[");
        b.append("shareAPNSData=");
        b.append(this.shareAPNSData);
        b.append(", ");
        b.append("shareUserExperienceAnalyticsData=");
        b.append(this.shareUserExperienceAnalyticsData);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
