package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.ContentAlignment;

@JsonPropertyOrder({
    "@odata.type", 
    "uiElementName", 
    "text", 
    "fontName", 
    "fontSize", 
    "fontColor", 
    "alignment", 
    "margin"})
@JsonInclude(Include.NON_NULL)
public class AddContentFooterAction extends InformationProtectionAction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("uiElementName")
    protected String uiElementName;

    @JsonProperty("text")
    protected String text;

    @JsonProperty("fontName")
    protected String fontName;

    @JsonProperty("fontSize")
    protected Integer fontSize;

    @JsonProperty("fontColor")
    protected String fontColor;

    @JsonProperty("alignment")
    protected ContentAlignment alignment;

    @JsonProperty("margin")
    protected Integer margin;

    protected AddContentFooterAction() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.addContentFooterAction";
    }

    @Property(name="uiElementName")
    @JsonIgnore
    public Optional<String> getUiElementName() {
        return Optional.ofNullable(uiElementName);
    }

    public AddContentFooterAction withUiElementName(String uiElementName) {
        AddContentFooterAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.addContentFooterAction");
        _x.uiElementName = uiElementName;
        return _x;
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    public AddContentFooterAction withText(String text) {
        AddContentFooterAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.addContentFooterAction");
        _x.text = text;
        return _x;
    }

    @Property(name="fontName")
    @JsonIgnore
    public Optional<String> getFontName() {
        return Optional.ofNullable(fontName);
    }

    public AddContentFooterAction withFontName(String fontName) {
        AddContentFooterAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.addContentFooterAction");
        _x.fontName = fontName;
        return _x;
    }

    @Property(name="fontSize")
    @JsonIgnore
    public Optional<Integer> getFontSize() {
        return Optional.ofNullable(fontSize);
    }

    public AddContentFooterAction withFontSize(Integer fontSize) {
        AddContentFooterAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.addContentFooterAction");
        _x.fontSize = fontSize;
        return _x;
    }

    @Property(name="fontColor")
    @JsonIgnore
    public Optional<String> getFontColor() {
        return Optional.ofNullable(fontColor);
    }

    public AddContentFooterAction withFontColor(String fontColor) {
        AddContentFooterAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.addContentFooterAction");
        _x.fontColor = fontColor;
        return _x;
    }

    @Property(name="alignment")
    @JsonIgnore
    public Optional<ContentAlignment> getAlignment() {
        return Optional.ofNullable(alignment);
    }

    public AddContentFooterAction withAlignment(ContentAlignment alignment) {
        AddContentFooterAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.addContentFooterAction");
        _x.alignment = alignment;
        return _x;
    }

    @Property(name="margin")
    @JsonIgnore
    public Optional<Integer> getMargin() {
        return Optional.ofNullable(margin);
    }

    public AddContentFooterAction withMargin(Integer margin) {
        AddContentFooterAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.addContentFooterAction");
        _x.margin = margin;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAddContentFooterAction() {
        return new Builder();
    }

    public static final class Builder {
        private String uiElementName;
        private String text;
        private String fontName;
        private Integer fontSize;
        private String fontColor;
        private ContentAlignment alignment;
        private Integer margin;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder uiElementName(String uiElementName) {
            this.uiElementName = uiElementName;
            this.changedFields = changedFields.add("uiElementName");
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public Builder fontName(String fontName) {
            this.fontName = fontName;
            this.changedFields = changedFields.add("fontName");
            return this;
        }

        public Builder fontSize(Integer fontSize) {
            this.fontSize = fontSize;
            this.changedFields = changedFields.add("fontSize");
            return this;
        }

        public Builder fontColor(String fontColor) {
            this.fontColor = fontColor;
            this.changedFields = changedFields.add("fontColor");
            return this;
        }

        public Builder alignment(ContentAlignment alignment) {
            this.alignment = alignment;
            this.changedFields = changedFields.add("alignment");
            return this;
        }

        public Builder margin(Integer margin) {
            this.margin = margin;
            this.changedFields = changedFields.add("margin");
            return this;
        }

        public AddContentFooterAction build() {
            AddContentFooterAction _x = new AddContentFooterAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.addContentFooterAction";
            _x.uiElementName = uiElementName;
            _x.text = text;
            _x.fontName = fontName;
            _x.fontSize = fontSize;
            _x.fontColor = fontColor;
            _x.alignment = alignment;
            _x.margin = margin;
            return _x;
        }
    }

    private AddContentFooterAction _copy() {
        AddContentFooterAction _x = new AddContentFooterAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.uiElementName = uiElementName;
        _x.text = text;
        _x.fontName = fontName;
        _x.fontSize = fontSize;
        _x.fontColor = fontColor;
        _x.alignment = alignment;
        _x.margin = margin;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AddContentFooterAction[");
        b.append("uiElementName=");
        b.append(this.uiElementName);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append(", ");
        b.append("fontName=");
        b.append(this.fontName);
        b.append(", ");
        b.append("fontSize=");
        b.append(this.fontSize);
        b.append(", ");
        b.append("fontColor=");
        b.append(this.fontColor);
        b.append(", ");
        b.append("alignment=");
        b.append(this.alignment);
        b.append(", ");
        b.append("margin=");
        b.append(this.margin);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
