package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "mailNotificationsEnabled", 
    "remindersEnabled", 
    "justificationRequiredOnApproval", 
    "recurrenceSettings", 
    "autoReviewEnabled", 
    "activityDurationInDays", 
    "autoReviewSettings", 
    "autoApplyReviewResultsEnabled", 
    "accessRecommendationsEnabled"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("mailNotificationsEnabled")
    protected Boolean mailNotificationsEnabled;

    @JsonProperty("remindersEnabled")
    protected Boolean remindersEnabled;

    @JsonProperty("justificationRequiredOnApproval")
    protected Boolean justificationRequiredOnApproval;

    @JsonProperty("recurrenceSettings")
    protected AccessReviewRecurrenceSettings recurrenceSettings;

    @JsonProperty("autoReviewEnabled")
    protected Boolean autoReviewEnabled;

    @JsonProperty("activityDurationInDays")
    protected Integer activityDurationInDays;

    @JsonProperty("autoReviewSettings")
    protected AutoReviewSettings autoReviewSettings;

    @JsonProperty("autoApplyReviewResultsEnabled")
    protected Boolean autoApplyReviewResultsEnabled;

    @JsonProperty("accessRecommendationsEnabled")
    protected Boolean accessRecommendationsEnabled;

    protected AccessReviewSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewSettings";
    }

    @Property(name="mailNotificationsEnabled")
    @JsonIgnore
    public Optional<Boolean> getMailNotificationsEnabled() {
        return Optional.ofNullable(mailNotificationsEnabled);
    }

    public AccessReviewSettings withMailNotificationsEnabled(Boolean mailNotificationsEnabled) {
        AccessReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewSettings");
        _x.mailNotificationsEnabled = mailNotificationsEnabled;
        return _x;
    }

    @Property(name="remindersEnabled")
    @JsonIgnore
    public Optional<Boolean> getRemindersEnabled() {
        return Optional.ofNullable(remindersEnabled);
    }

    public AccessReviewSettings withRemindersEnabled(Boolean remindersEnabled) {
        AccessReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewSettings");
        _x.remindersEnabled = remindersEnabled;
        return _x;
    }

    @Property(name="justificationRequiredOnApproval")
    @JsonIgnore
    public Optional<Boolean> getJustificationRequiredOnApproval() {
        return Optional.ofNullable(justificationRequiredOnApproval);
    }

    public AccessReviewSettings withJustificationRequiredOnApproval(Boolean justificationRequiredOnApproval) {
        AccessReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewSettings");
        _x.justificationRequiredOnApproval = justificationRequiredOnApproval;
        return _x;
    }

    @Property(name="recurrenceSettings")
    @JsonIgnore
    public Optional<AccessReviewRecurrenceSettings> getRecurrenceSettings() {
        return Optional.ofNullable(recurrenceSettings);
    }

    public AccessReviewSettings withRecurrenceSettings(AccessReviewRecurrenceSettings recurrenceSettings) {
        AccessReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewSettings");
        _x.recurrenceSettings = recurrenceSettings;
        return _x;
    }

    @Property(name="autoReviewEnabled")
    @JsonIgnore
    public Optional<Boolean> getAutoReviewEnabled() {
        return Optional.ofNullable(autoReviewEnabled);
    }

    public AccessReviewSettings withAutoReviewEnabled(Boolean autoReviewEnabled) {
        AccessReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewSettings");
        _x.autoReviewEnabled = autoReviewEnabled;
        return _x;
    }

    @Property(name="activityDurationInDays")
    @JsonIgnore
    public Optional<Integer> getActivityDurationInDays() {
        return Optional.ofNullable(activityDurationInDays);
    }

    public AccessReviewSettings withActivityDurationInDays(Integer activityDurationInDays) {
        AccessReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewSettings");
        _x.activityDurationInDays = activityDurationInDays;
        return _x;
    }

    @Property(name="autoReviewSettings")
    @JsonIgnore
    public Optional<AutoReviewSettings> getAutoReviewSettings() {
        return Optional.ofNullable(autoReviewSettings);
    }

    public AccessReviewSettings withAutoReviewSettings(AutoReviewSettings autoReviewSettings) {
        AccessReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewSettings");
        _x.autoReviewSettings = autoReviewSettings;
        return _x;
    }

    @Property(name="autoApplyReviewResultsEnabled")
    @JsonIgnore
    public Optional<Boolean> getAutoApplyReviewResultsEnabled() {
        return Optional.ofNullable(autoApplyReviewResultsEnabled);
    }

    public AccessReviewSettings withAutoApplyReviewResultsEnabled(Boolean autoApplyReviewResultsEnabled) {
        AccessReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewSettings");
        _x.autoApplyReviewResultsEnabled = autoApplyReviewResultsEnabled;
        return _x;
    }

    @Property(name="accessRecommendationsEnabled")
    @JsonIgnore
    public Optional<Boolean> getAccessRecommendationsEnabled() {
        return Optional.ofNullable(accessRecommendationsEnabled);
    }

    public AccessReviewSettings withAccessRecommendationsEnabled(Boolean accessRecommendationsEnabled) {
        AccessReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewSettings");
        _x.accessRecommendationsEnabled = accessRecommendationsEnabled;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean mailNotificationsEnabled;
        private Boolean remindersEnabled;
        private Boolean justificationRequiredOnApproval;
        private AccessReviewRecurrenceSettings recurrenceSettings;
        private Boolean autoReviewEnabled;
        private Integer activityDurationInDays;
        private AutoReviewSettings autoReviewSettings;
        private Boolean autoApplyReviewResultsEnabled;
        private Boolean accessRecommendationsEnabled;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder mailNotificationsEnabled(Boolean mailNotificationsEnabled) {
            this.mailNotificationsEnabled = mailNotificationsEnabled;
            this.changedFields = changedFields.add("mailNotificationsEnabled");
            return this;
        }

        public Builder remindersEnabled(Boolean remindersEnabled) {
            this.remindersEnabled = remindersEnabled;
            this.changedFields = changedFields.add("remindersEnabled");
            return this;
        }

        public Builder justificationRequiredOnApproval(Boolean justificationRequiredOnApproval) {
            this.justificationRequiredOnApproval = justificationRequiredOnApproval;
            this.changedFields = changedFields.add("justificationRequiredOnApproval");
            return this;
        }

        public Builder recurrenceSettings(AccessReviewRecurrenceSettings recurrenceSettings) {
            this.recurrenceSettings = recurrenceSettings;
            this.changedFields = changedFields.add("recurrenceSettings");
            return this;
        }

        public Builder autoReviewEnabled(Boolean autoReviewEnabled) {
            this.autoReviewEnabled = autoReviewEnabled;
            this.changedFields = changedFields.add("autoReviewEnabled");
            return this;
        }

        public Builder activityDurationInDays(Integer activityDurationInDays) {
            this.activityDurationInDays = activityDurationInDays;
            this.changedFields = changedFields.add("activityDurationInDays");
            return this;
        }

        public Builder autoReviewSettings(AutoReviewSettings autoReviewSettings) {
            this.autoReviewSettings = autoReviewSettings;
            this.changedFields = changedFields.add("autoReviewSettings");
            return this;
        }

        public Builder autoApplyReviewResultsEnabled(Boolean autoApplyReviewResultsEnabled) {
            this.autoApplyReviewResultsEnabled = autoApplyReviewResultsEnabled;
            this.changedFields = changedFields.add("autoApplyReviewResultsEnabled");
            return this;
        }

        public Builder accessRecommendationsEnabled(Boolean accessRecommendationsEnabled) {
            this.accessRecommendationsEnabled = accessRecommendationsEnabled;
            this.changedFields = changedFields.add("accessRecommendationsEnabled");
            return this;
        }

        public AccessReviewSettings build() {
            AccessReviewSettings _x = new AccessReviewSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.accessReviewSettings";
            _x.mailNotificationsEnabled = mailNotificationsEnabled;
            _x.remindersEnabled = remindersEnabled;
            _x.justificationRequiredOnApproval = justificationRequiredOnApproval;
            _x.recurrenceSettings = recurrenceSettings;
            _x.autoReviewEnabled = autoReviewEnabled;
            _x.activityDurationInDays = activityDurationInDays;
            _x.autoReviewSettings = autoReviewSettings;
            _x.autoApplyReviewResultsEnabled = autoApplyReviewResultsEnabled;
            _x.accessRecommendationsEnabled = accessRecommendationsEnabled;
            return _x;
        }
    }

    private AccessReviewSettings _copy() {
        AccessReviewSettings _x = new AccessReviewSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.mailNotificationsEnabled = mailNotificationsEnabled;
        _x.remindersEnabled = remindersEnabled;
        _x.justificationRequiredOnApproval = justificationRequiredOnApproval;
        _x.recurrenceSettings = recurrenceSettings;
        _x.autoReviewEnabled = autoReviewEnabled;
        _x.activityDurationInDays = activityDurationInDays;
        _x.autoReviewSettings = autoReviewSettings;
        _x.autoApplyReviewResultsEnabled = autoApplyReviewResultsEnabled;
        _x.accessRecommendationsEnabled = accessRecommendationsEnabled;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewSettings[");
        b.append("mailNotificationsEnabled=");
        b.append(this.mailNotificationsEnabled);
        b.append(", ");
        b.append("remindersEnabled=");
        b.append(this.remindersEnabled);
        b.append(", ");
        b.append("justificationRequiredOnApproval=");
        b.append(this.justificationRequiredOnApproval);
        b.append(", ");
        b.append("recurrenceSettings=");
        b.append(this.recurrenceSettings);
        b.append(", ");
        b.append("autoReviewEnabled=");
        b.append(this.autoReviewEnabled);
        b.append(", ");
        b.append("activityDurationInDays=");
        b.append(this.activityDurationInDays);
        b.append(", ");
        b.append("autoReviewSettings=");
        b.append(this.autoReviewSettings);
        b.append(", ");
        b.append("autoApplyReviewResultsEnabled=");
        b.append(this.autoApplyReviewResultsEnabled);
        b.append(", ");
        b.append("accessRecommendationsEnabled=");
        b.append(this.accessRecommendationsEnabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
