package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "query", 
    "queryType"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewScope implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("query")
    protected String query;

    @JsonProperty("queryType")
    protected String queryType;

    protected AccessReviewScope() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewScope";
    }

    @Property(name="query")
    @JsonIgnore
    public Optional<String> getQuery() {
        return Optional.ofNullable(query);
    }

    public AccessReviewScope withQuery(String query) {
        AccessReviewScope _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScope");
        _x.query = query;
        return _x;
    }

    @Property(name="queryType")
    @JsonIgnore
    public Optional<String> getQueryType() {
        return Optional.ofNullable(queryType);
    }

    public AccessReviewScope withQueryType(String queryType) {
        AccessReviewScope _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScope");
        _x.queryType = queryType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String query;
        private String queryType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder query(String query) {
            this.query = query;
            this.changedFields = changedFields.add("query");
            return this;
        }

        public Builder queryType(String queryType) {
            this.queryType = queryType;
            this.changedFields = changedFields.add("queryType");
            return this;
        }

        public AccessReviewScope build() {
            AccessReviewScope _x = new AccessReviewScope();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.accessReviewScope";
            _x.query = query;
            _x.queryType = queryType;
            return _x;
        }
    }

    private AccessReviewScope _copy() {
        AccessReviewScope _x = new AccessReviewScope();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.query = query;
        _x.queryType = queryType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewScope[");
        b.append("query=");
        b.append(this.query);
        b.append(", ");
        b.append("queryType=");
        b.append(this.queryType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
