package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "recurrenceType", 
    "recurrenceEndType", 
    "durationInDays", 
    "recurrenceCount"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewRecurrenceSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("recurrenceType")
    protected String recurrenceType;

    @JsonProperty("recurrenceEndType")
    protected String recurrenceEndType;

    @JsonProperty("durationInDays")
    protected Integer durationInDays;

    @JsonProperty("recurrenceCount")
    protected Integer recurrenceCount;

    protected AccessReviewRecurrenceSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewRecurrenceSettings";
    }

    @Property(name="recurrenceType")
    @JsonIgnore
    public Optional<String> getRecurrenceType() {
        return Optional.ofNullable(recurrenceType);
    }

    public AccessReviewRecurrenceSettings withRecurrenceType(String recurrenceType) {
        AccessReviewRecurrenceSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewRecurrenceSettings");
        _x.recurrenceType = recurrenceType;
        return _x;
    }

    @Property(name="recurrenceEndType")
    @JsonIgnore
    public Optional<String> getRecurrenceEndType() {
        return Optional.ofNullable(recurrenceEndType);
    }

    public AccessReviewRecurrenceSettings withRecurrenceEndType(String recurrenceEndType) {
        AccessReviewRecurrenceSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewRecurrenceSettings");
        _x.recurrenceEndType = recurrenceEndType;
        return _x;
    }

    @Property(name="durationInDays")
    @JsonIgnore
    public Optional<Integer> getDurationInDays() {
        return Optional.ofNullable(durationInDays);
    }

    public AccessReviewRecurrenceSettings withDurationInDays(Integer durationInDays) {
        AccessReviewRecurrenceSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewRecurrenceSettings");
        _x.durationInDays = durationInDays;
        return _x;
    }

    @Property(name="recurrenceCount")
    @JsonIgnore
    public Optional<Integer> getRecurrenceCount() {
        return Optional.ofNullable(recurrenceCount);
    }

    public AccessReviewRecurrenceSettings withRecurrenceCount(Integer recurrenceCount) {
        AccessReviewRecurrenceSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewRecurrenceSettings");
        _x.recurrenceCount = recurrenceCount;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String recurrenceType;
        private String recurrenceEndType;
        private Integer durationInDays;
        private Integer recurrenceCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder recurrenceType(String recurrenceType) {
            this.recurrenceType = recurrenceType;
            this.changedFields = changedFields.add("recurrenceType");
            return this;
        }

        public Builder recurrenceEndType(String recurrenceEndType) {
            this.recurrenceEndType = recurrenceEndType;
            this.changedFields = changedFields.add("recurrenceEndType");
            return this;
        }

        public Builder durationInDays(Integer durationInDays) {
            this.durationInDays = durationInDays;
            this.changedFields = changedFields.add("durationInDays");
            return this;
        }

        public Builder recurrenceCount(Integer recurrenceCount) {
            this.recurrenceCount = recurrenceCount;
            this.changedFields = changedFields.add("recurrenceCount");
            return this;
        }

        public AccessReviewRecurrenceSettings build() {
            AccessReviewRecurrenceSettings _x = new AccessReviewRecurrenceSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.accessReviewRecurrenceSettings";
            _x.recurrenceType = recurrenceType;
            _x.recurrenceEndType = recurrenceEndType;
            _x.durationInDays = durationInDays;
            _x.recurrenceCount = recurrenceCount;
            return _x;
        }
    }

    private AccessReviewRecurrenceSettings _copy() {
        AccessReviewRecurrenceSettings _x = new AccessReviewRecurrenceSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.recurrenceType = recurrenceType;
        _x.recurrenceEndType = recurrenceEndType;
        _x.durationInDays = durationInDays;
        _x.recurrenceCount = recurrenceCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewRecurrenceSettings[");
        b.append("recurrenceType=");
        b.append(this.recurrenceType);
        b.append(", ");
        b.append("recurrenceEndType=");
        b.append(this.recurrenceEndType);
        b.append(", ");
        b.append("durationInDays=");
        b.append(this.durationInDays);
        b.append(", ");
        b.append("recurrenceCount=");
        b.append(this.recurrenceCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
