package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "userId", 
    "userDisplayName", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewInstanceDecisionItemUserTarget extends AccessReviewInstanceDecisionItemTarget implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userDisplayName")
    protected String userDisplayName;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected AccessReviewInstanceDecisionItemUserTarget() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewInstanceDecisionItemUserTarget";
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public AccessReviewInstanceDecisionItemUserTarget withUserId(String userId) {
        AccessReviewInstanceDecisionItemUserTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItemUserTarget");
        _x.userId = userId;
        return _x;
    }

    @Property(name="userDisplayName")
    @JsonIgnore
    public Optional<String> getUserDisplayName() {
        return Optional.ofNullable(userDisplayName);
    }

    public AccessReviewInstanceDecisionItemUserTarget withUserDisplayName(String userDisplayName) {
        AccessReviewInstanceDecisionItemUserTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItemUserTarget");
        _x.userDisplayName = userDisplayName;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public AccessReviewInstanceDecisionItemUserTarget withUserPrincipalName(String userPrincipalName) {
        AccessReviewInstanceDecisionItemUserTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItemUserTarget");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewInstanceDecisionItemUserTarget() {
        return new Builder();
    }

    public static final class Builder {
        private String userId;
        private String userDisplayName;
        private String userPrincipalName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public AccessReviewInstanceDecisionItemUserTarget build() {
            AccessReviewInstanceDecisionItemUserTarget _x = new AccessReviewInstanceDecisionItemUserTarget();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.accessReviewInstanceDecisionItemUserTarget";
            _x.userId = userId;
            _x.userDisplayName = userDisplayName;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    private AccessReviewInstanceDecisionItemUserTarget _copy() {
        AccessReviewInstanceDecisionItemUserTarget _x = new AccessReviewInstanceDecisionItemUserTarget();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.userId = userId;
        _x.userDisplayName = userDisplayName;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewInstanceDecisionItemUserTarget[");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
