package odata.msgraph.client.beta.callRecords.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WifiRadioType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("wifi80211a")
    WIFI80211A("wifi80211a", "1"),

    @JsonProperty("wifi80211b")
    WIFI80211B("wifi80211b", "2"),

    @JsonProperty("wifi80211g")
    WIFI80211G("wifi80211g", "3"),

    @JsonProperty("wifi80211n")
    WIFI80211N("wifi80211n", "4"),

    @JsonProperty("wifi80211ac")
    WIFI80211AC("wifi80211ac", "5"),

    @JsonProperty("wifi80211ax")
    WIFI80211AX("wifi80211ax", "6"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "7");

    private final String name;
    private final String value;

    private WifiRadioType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
