package odata.msgraph.client.beta.callRecords.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WifiBand implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("frequency24GHz")
    FREQUENCY24GHZ("frequency24GHz", "1"),

    @JsonProperty("frequency50GHz")
    FREQUENCY50GHZ("frequency50GHz", "2"),

    @JsonProperty("frequency60GHz")
    FREQUENCY60GHZ("frequency60GHz", "3"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private WifiBand(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
