package odata.msgraph.client.beta.callRecords.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum UserFeedbackRating implements Enum {

    @JsonProperty("notRated")
    NOT_RATED("notRated", "0"),

    @JsonProperty("bad")
    BAD("bad", "1"),

    @JsonProperty("poor")
    POOR("poor", "2"),

    @JsonProperty("fair")
    FAIR("fair", "3"),

    @JsonProperty("good")
    GOOD("good", "4"),

    @JsonProperty("excellent")
    EXCELLENT("excellent", "5"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private UserFeedbackRating(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
