package odata.msgraph.client.beta.callRecords.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Modality implements Enum {

    @JsonProperty("audio")
    AUDIO("audio", "0"),

    @JsonProperty("video")
    VIDEO("video", "1"),

    @JsonProperty("videoBasedScreenSharing")
    VIDEO_BASED_SCREEN_SHARING("videoBasedScreenSharing", "2"),

    @JsonProperty("data")
    DATA("data", "3"),

    @JsonProperty("screenSharing")
    SCREEN_SHARING("screenSharing", "4"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private Modality(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
