package odata.msgraph.client.beta.callRecords.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ClientPlatform implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("windows")
    WINDOWS("windows", "1"),

    @JsonProperty("macOS")
    MAC_OS("macOS", "2"),

    @JsonProperty("iOS")
    I_OS("iOS", "3"),

    @JsonProperty("android")
    ANDROID("android", "4"),

    @JsonProperty("web")
    WEB("web", "5"),

    @JsonProperty("ipPhone")
    IP_PHONE("ipPhone", "6"),

    @JsonProperty("roomSystem")
    ROOM_SYSTEM("roomSystem", "7"),

    @JsonProperty("surfaceHub")
    SURFACE_HUB("surfaceHub", "8"),

    @JsonProperty("holoLens")
    HOLO_LENS("holoLens", "9"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "10");

    private final String name;
    private final String value;

    private ClientPlatform(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
