package odata.msgraph.client.beta.callRecords.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.callRecords.entity.Session;
import odata.msgraph.client.beta.callRecords.entity.collection.request.SegmentCollectionRequest;
import odata.msgraph.client.beta.callRecords.schema.SchemaInfo;

@JsonIgnoreType
public class SessionRequest extends EntityRequest<Session> {

    public SessionRequest(ContextPath contextPath) {
        super(Session.class, contextPath, SchemaInfo.INSTANCE);
    }

    public SegmentCollectionRequest segments() {
        return new SegmentCollectionRequest(
                        contextPath.addSegment("segments"));
    }

    public SegmentRequest segments(String id) {
        return new SegmentRequest(contextPath.addSegment("segments").addKeys(new NameValue(id.toString())));
    }

}
