package odata.msgraph.client.beta.callRecords.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.callRecords.entity.CallRecord;
import odata.msgraph.client.beta.callRecords.entity.collection.request.SessionCollectionRequest;
import odata.msgraph.client.beta.callRecords.schema.SchemaInfo;

@JsonIgnoreType
public class CallRecordRequest extends EntityRequest<CallRecord> {

    public CallRecordRequest(ContextPath contextPath) {
        super(CallRecord.class, contextPath, SchemaInfo.INSTANCE);
    }

    public SessionCollectionRequest sessions() {
        return new SessionCollectionRequest(
                        contextPath.addSegment("sessions"));
    }

    public SessionRequest sessions(String id) {
        return new SessionRequest(contextPath.addSegment("sessions").addKeys(new NameValue(id.toString())));
    }

}
