package odata.msgraph.client.beta.callRecords.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.callRecords.entity.Session;
import odata.msgraph.client.beta.callRecords.entity.request.SegmentRequest;
import odata.msgraph.client.beta.callRecords.entity.request.SessionRequest;
import odata.msgraph.client.beta.callRecords.schema.SchemaInfo;

public class SessionCollectionRequest extends CollectionPageEntityRequest<Session, SessionRequest>{

    protected ContextPath contextPath;

    public SessionCollectionRequest(ContextPath contextPath) {
        super(contextPath, Session.class, cp -> new SessionRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public SegmentCollectionRequest segments() {
        return new SegmentCollectionRequest(contextPath.addSegment("segments"));
    }

    public SegmentRequest segments(String id) {
        return new SegmentRequest(contextPath.addSegment("segments").addKeys(new NameValue(id.toString())));
    }

}
