package odata.msgraph.client.beta.callRecords.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.callRecords.entity.CallRecord;
import odata.msgraph.client.beta.callRecords.entity.request.CallRecordRequest;
import odata.msgraph.client.beta.callRecords.entity.request.SessionRequest;
import odata.msgraph.client.beta.callRecords.schema.SchemaInfo;

public class CallRecordCollectionRequest extends CollectionPageEntityRequest<CallRecord, CallRecordRequest>{

    protected ContextPath contextPath;

    public CallRecordCollectionRequest(ContextPath contextPath) {
        super(contextPath, CallRecord.class, cp -> new CallRecordRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public SessionCollectionRequest sessions() {
        return new SessionCollectionRequest(contextPath.addSegment("sessions"));
    }

    public SessionRequest sessions(String id) {
        return new SessionRequest(contextPath.addSegment("sessions").addKeys(new NameValue(id.toString())));
    }

}
