package odata.msgraph.client.beta.callRecords.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.callRecords.complex.Endpoint;
import odata.msgraph.client.beta.callRecords.complex.FailureInfo;
import odata.msgraph.client.beta.callRecords.entity.collection.request.SegmentCollectionRequest;
import odata.msgraph.client.beta.callRecords.enums.Modality;
import odata.msgraph.client.beta.callRecords.schema.SchemaInfo;
import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "modalities", 
    "startDateTime", 
    "endDateTime", 
    "caller", 
    "callee", 
    "failureInfo"})
@JsonInclude(Include.NON_NULL)
public class Session extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRecords.session";
    }

    @JsonProperty("modalities")
    protected List<Modality> modalities;

    @JsonProperty("modalities@nextLink")
    protected String modalitiesNextLink;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("caller")
    protected Endpoint caller;

    @JsonProperty("callee")
    protected Endpoint callee;

    @JsonProperty("failureInfo")
    protected FailureInfo failureInfo;

    protected Session() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSession() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<Modality> modalities;
        private String modalitiesNextLink;
        private OffsetDateTime startDateTime;
        private OffsetDateTime endDateTime;
        private Endpoint caller;
        private Endpoint callee;
        private FailureInfo failureInfo;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder modalities(List<Modality> modalities) {
            this.modalities = modalities;
            this.changedFields = changedFields.add("modalities");
            return this;
        }

        public Builder modalities(Modality... modalities) {
            return modalities(Arrays.asList(modalities));
        }

        public Builder modalitiesNextLink(String modalitiesNextLink) {
            this.modalitiesNextLink = modalitiesNextLink;
            this.changedFields = changedFields.add("modalities");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder caller(Endpoint caller) {
            this.caller = caller;
            this.changedFields = changedFields.add("caller");
            return this;
        }

        public Builder callee(Endpoint callee) {
            this.callee = callee;
            this.changedFields = changedFields.add("callee");
            return this;
        }

        public Builder failureInfo(FailureInfo failureInfo) {
            this.failureInfo = failureInfo;
            this.changedFields = changedFields.add("failureInfo");
            return this;
        }

        public Session build() {
            Session _x = new Session();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.callRecords.session";
            _x.id = id;
            _x.modalities = modalities;
            _x.modalitiesNextLink = modalitiesNextLink;
            _x.startDateTime = startDateTime;
            _x.endDateTime = endDateTime;
            _x.caller = caller;
            _x.callee = callee;
            _x.failureInfo = failureInfo;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="modalities")
    @JsonIgnore
    public CollectionPage<Modality> getModalities() {
        return new CollectionPage<Modality>(contextPath, Modality.class, modalities, Optional.ofNullable(modalitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="modalities")
    @JsonIgnore
    public CollectionPage<Modality> getModalities(HttpRequestOptions options) {
        return new CollectionPage<Modality>(contextPath, Modality.class, modalities, Optional.ofNullable(modalitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public Session withStartDateTime(OffsetDateTime startDateTime) {
        Session _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.session");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public Session withEndDateTime(OffsetDateTime endDateTime) {
        Session _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.session");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="caller")
    @JsonIgnore
    public Optional<Endpoint> getCaller() {
        return Optional.ofNullable(caller);
    }

    public Session withCaller(Endpoint caller) {
        Session _x = _copy();
        _x.changedFields = changedFields.add("caller");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.session");
        _x.caller = caller;
        return _x;
    }

    @Property(name="callee")
    @JsonIgnore
    public Optional<Endpoint> getCallee() {
        return Optional.ofNullable(callee);
    }

    public Session withCallee(Endpoint callee) {
        Session _x = _copy();
        _x.changedFields = changedFields.add("callee");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.session");
        _x.callee = callee;
        return _x;
    }

    @Property(name="failureInfo")
    @JsonIgnore
    public Optional<FailureInfo> getFailureInfo() {
        return Optional.ofNullable(failureInfo);
    }

    public Session withFailureInfo(FailureInfo failureInfo) {
        Session _x = _copy();
        _x.changedFields = changedFields.add("failureInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.session");
        _x.failureInfo = failureInfo;
        return _x;
    }

    @NavigationProperty(name="segments")
    @JsonIgnore
    public SegmentCollectionRequest getSegments() {
        return new SegmentCollectionRequest(
                        contextPath.addSegment("segments"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Session patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Session _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Session put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Session _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Session _copy() {
        Session _x = new Session();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.modalities = modalities;
        _x.startDateTime = startDateTime;
        _x.endDateTime = endDateTime;
        _x.caller = caller;
        _x.callee = callee;
        _x.failureInfo = failureInfo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Session[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("modalities=");
        b.append(this.modalities);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("caller=");
        b.append(this.caller);
        b.append(", ");
        b.append("callee=");
        b.append(this.callee);
        b.append(", ");
        b.append("failureInfo=");
        b.append(this.failureInfo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
