package odata.msgraph.client.beta.callRecords.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.callRecords.enums.UserFeedbackRating;

@JsonPropertyOrder({
    "@odata.type", 
    "text", 
    "rating", 
    "tokens"})
@JsonInclude(Include.NON_NULL)
public class UserFeedback implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("text")
    protected String text;

    @JsonProperty("rating")
    protected UserFeedbackRating rating;

    @JsonProperty("tokens")
    protected FeedbackTokenSet tokens;

    protected UserFeedback() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRecords.userFeedback";
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    public UserFeedback withText(String text) {
        UserFeedback _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.userFeedback");
        _x.text = text;
        return _x;
    }

    @Property(name="rating")
    @JsonIgnore
    public Optional<UserFeedbackRating> getRating() {
        return Optional.ofNullable(rating);
    }

    public UserFeedback withRating(UserFeedbackRating rating) {
        UserFeedback _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.userFeedback");
        _x.rating = rating;
        return _x;
    }

    @Property(name="tokens")
    @JsonIgnore
    public Optional<FeedbackTokenSet> getTokens() {
        return Optional.ofNullable(tokens);
    }

    public UserFeedback withTokens(FeedbackTokenSet tokens) {
        UserFeedback _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.userFeedback");
        _x.tokens = tokens;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String text;
        private UserFeedbackRating rating;
        private FeedbackTokenSet tokens;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder text(String text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public Builder rating(UserFeedbackRating rating) {
            this.rating = rating;
            this.changedFields = changedFields.add("rating");
            return this;
        }

        public Builder tokens(FeedbackTokenSet tokens) {
            this.tokens = tokens;
            this.changedFields = changedFields.add("tokens");
            return this;
        }

        public UserFeedback build() {
            UserFeedback _x = new UserFeedback();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.callRecords.userFeedback";
            _x.text = text;
            _x.rating = rating;
            _x.tokens = tokens;
            return _x;
        }
    }

    private UserFeedback _copy() {
        UserFeedback _x = new UserFeedback();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.text = text;
        _x.rating = rating;
        _x.tokens = tokens;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserFeedback[");
        b.append("text=");
        b.append(this.text);
        b.append(", ");
        b.append("rating=");
        b.append(this.rating);
        b.append(", ");
        b.append("tokens=");
        b.append(this.tokens);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
