package odata.msgraph.client.beta.callRecords.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "headerValue", 
    "applicationVersion"})
@JsonInclude(Include.NON_NULL)
public class UserAgent implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("headerValue")
    protected String headerValue;

    @JsonProperty("applicationVersion")
    protected String applicationVersion;

    protected UserAgent() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRecords.userAgent";
    }

    @Property(name="headerValue")
    @JsonIgnore
    public Optional<String> getHeaderValue() {
        return Optional.ofNullable(headerValue);
    }

    public UserAgent withHeaderValue(String headerValue) {
        UserAgent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.userAgent");
        _x.headerValue = headerValue;
        return _x;
    }

    @Property(name="applicationVersion")
    @JsonIgnore
    public Optional<String> getApplicationVersion() {
        return Optional.ofNullable(applicationVersion);
    }

    public UserAgent withApplicationVersion(String applicationVersion) {
        UserAgent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.userAgent");
        _x.applicationVersion = applicationVersion;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private UserAgent _copy() {
        UserAgent _x = new UserAgent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.headerValue = headerValue;
        _x.applicationVersion = applicationVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserAgent[");
        b.append("headerValue=");
        b.append(this.headerValue);
        b.append(", ");
        b.append("applicationVersion=");
        b.append(this.applicationVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
