package odata.msgraph.client.beta.callRecords.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;

@JsonPropertyOrder({
    "@odata.type", 
    "identity", 
    "feedback"})
@JsonInclude(Include.NON_NULL)
public class ParticipantEndpoint extends Endpoint implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("identity")
    protected IdentitySet identity;

    @JsonProperty("feedback")
    protected UserFeedback feedback;

    protected ParticipantEndpoint() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRecords.participantEndpoint";
    }

    @Property(name="identity")
    @JsonIgnore
    public Optional<IdentitySet> getIdentity() {
        return Optional.ofNullable(identity);
    }

    public ParticipantEndpoint withIdentity(IdentitySet identity) {
        ParticipantEndpoint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.participantEndpoint");
        _x.identity = identity;
        return _x;
    }

    @Property(name="feedback")
    @JsonIgnore
    public Optional<UserFeedback> getFeedback() {
        return Optional.ofNullable(feedback);
    }

    public ParticipantEndpoint withFeedback(UserFeedback feedback) {
        ParticipantEndpoint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.participantEndpoint");
        _x.feedback = feedback;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderParticipantEndpoint() {
        return new Builder();
    }

    public static final class Builder {
        private UserAgent userAgent;
        private IdentitySet identity;
        private UserFeedback feedback;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder userAgent(UserAgent userAgent) {
            this.userAgent = userAgent;
            this.changedFields = changedFields.add("userAgent");
            return this;
        }

        public Builder identity(IdentitySet identity) {
            this.identity = identity;
            this.changedFields = changedFields.add("identity");
            return this;
        }

        public Builder feedback(UserFeedback feedback) {
            this.feedback = feedback;
            this.changedFields = changedFields.add("feedback");
            return this;
        }

        public ParticipantEndpoint build() {
            ParticipantEndpoint _x = new ParticipantEndpoint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.callRecords.participantEndpoint";
            _x.userAgent = userAgent;
            _x.identity = identity;
            _x.feedback = feedback;
            return _x;
        }
    }

    private ParticipantEndpoint _copy() {
        ParticipantEndpoint _x = new ParticipantEndpoint();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.userAgent = userAgent;
        _x.identity = identity;
        _x.feedback = feedback;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ParticipantEndpoint[");
        b.append("userAgent=");
        b.append(this.userAgent);
        b.append(", ");
        b.append("identity=");
        b.append(this.identity);
        b.append(", ");
        b.append("feedback=");
        b.append(this.feedback);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
