package odata.msgraph.client.beta.callRecords.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.callRecords.enums.NetworkConnectionType;
import odata.msgraph.client.beta.callRecords.enums.WifiBand;
import odata.msgraph.client.beta.callRecords.enums.WifiRadioType;

@JsonPropertyOrder({
    "@odata.type", 
    "ipAddress", 
    "subnet", 
    "linkSpeed", 
    "connectionType", 
    "port", 
    "reflexiveIPAddress", 
    "relayIPAddress", 
    "relayPort", 
    "macAddress", 
    "wifiMicrosoftDriver", 
    "wifiMicrosoftDriverVersion", 
    "wifiVendorDriver", 
    "wifiVendorDriverVersion", 
    "wifiChannel", 
    "wifiBand", 
    "basicServiceSetIdentifier", 
    "wifiRadioType", 
    "wifiSignalStrength", 
    "wifiBatteryCharge", 
    "dnsSuffix", 
    "sentQualityEventRatio", 
    "receivedQualityEventRatio", 
    "delayEventRatio", 
    "bandwidthLowEventRatio"})
@JsonInclude(Include.NON_NULL)
public class NetworkInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ipAddress")
    protected String ipAddress;

    @JsonProperty("subnet")
    protected String subnet;

    @JsonProperty("linkSpeed")
    protected Long linkSpeed;

    @JsonProperty("connectionType")
    protected NetworkConnectionType connectionType;

    @JsonProperty("port")
    protected Integer port;

    @JsonProperty("reflexiveIPAddress")
    protected String reflexiveIPAddress;

    @JsonProperty("relayIPAddress")
    protected String relayIPAddress;

    @JsonProperty("relayPort")
    protected Integer relayPort;

    @JsonProperty("macAddress")
    protected String macAddress;

    @JsonProperty("wifiMicrosoftDriver")
    protected String wifiMicrosoftDriver;

    @JsonProperty("wifiMicrosoftDriverVersion")
    protected String wifiMicrosoftDriverVersion;

    @JsonProperty("wifiVendorDriver")
    protected String wifiVendorDriver;

    @JsonProperty("wifiVendorDriverVersion")
    protected String wifiVendorDriverVersion;

    @JsonProperty("wifiChannel")
    protected Integer wifiChannel;

    @JsonProperty("wifiBand")
    protected WifiBand wifiBand;

    @JsonProperty("basicServiceSetIdentifier")
    protected String basicServiceSetIdentifier;

    @JsonProperty("wifiRadioType")
    protected WifiRadioType wifiRadioType;

    @JsonProperty("wifiSignalStrength")
    protected Integer wifiSignalStrength;

    @JsonProperty("wifiBatteryCharge")
    protected Integer wifiBatteryCharge;

    @JsonProperty("dnsSuffix")
    protected String dnsSuffix;

    @JsonProperty("sentQualityEventRatio")
    protected Float sentQualityEventRatio;

    @JsonProperty("receivedQualityEventRatio")
    protected Float receivedQualityEventRatio;

    @JsonProperty("delayEventRatio")
    protected Float delayEventRatio;

    @JsonProperty("bandwidthLowEventRatio")
    protected Float bandwidthLowEventRatio;

    protected NetworkInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRecords.networkInfo";
    }

    @Property(name="ipAddress")
    @JsonIgnore
    public Optional<String> getIpAddress() {
        return Optional.ofNullable(ipAddress);
    }

    public NetworkInfo withIpAddress(String ipAddress) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.ipAddress = ipAddress;
        return _x;
    }

    @Property(name="subnet")
    @JsonIgnore
    public Optional<String> getSubnet() {
        return Optional.ofNullable(subnet);
    }

    public NetworkInfo withSubnet(String subnet) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.subnet = subnet;
        return _x;
    }

    @Property(name="linkSpeed")
    @JsonIgnore
    public Optional<Long> getLinkSpeed() {
        return Optional.ofNullable(linkSpeed);
    }

    public NetworkInfo withLinkSpeed(Long linkSpeed) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.linkSpeed = linkSpeed;
        return _x;
    }

    @Property(name="connectionType")
    @JsonIgnore
    public Optional<NetworkConnectionType> getConnectionType() {
        return Optional.ofNullable(connectionType);
    }

    public NetworkInfo withConnectionType(NetworkConnectionType connectionType) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.connectionType = connectionType;
        return _x;
    }

    @Property(name="port")
    @JsonIgnore
    public Optional<Integer> getPort() {
        return Optional.ofNullable(port);
    }

    public NetworkInfo withPort(Integer port) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.port = port;
        return _x;
    }

    @Property(name="reflexiveIPAddress")
    @JsonIgnore
    public Optional<String> getReflexiveIPAddress() {
        return Optional.ofNullable(reflexiveIPAddress);
    }

    public NetworkInfo withReflexiveIPAddress(String reflexiveIPAddress) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.reflexiveIPAddress = reflexiveIPAddress;
        return _x;
    }

    @Property(name="relayIPAddress")
    @JsonIgnore
    public Optional<String> getRelayIPAddress() {
        return Optional.ofNullable(relayIPAddress);
    }

    public NetworkInfo withRelayIPAddress(String relayIPAddress) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.relayIPAddress = relayIPAddress;
        return _x;
    }

    @Property(name="relayPort")
    @JsonIgnore
    public Optional<Integer> getRelayPort() {
        return Optional.ofNullable(relayPort);
    }

    public NetworkInfo withRelayPort(Integer relayPort) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.relayPort = relayPort;
        return _x;
    }

    @Property(name="macAddress")
    @JsonIgnore
    public Optional<String> getMacAddress() {
        return Optional.ofNullable(macAddress);
    }

    public NetworkInfo withMacAddress(String macAddress) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.macAddress = macAddress;
        return _x;
    }

    @Property(name="wifiMicrosoftDriver")
    @JsonIgnore
    public Optional<String> getWifiMicrosoftDriver() {
        return Optional.ofNullable(wifiMicrosoftDriver);
    }

    public NetworkInfo withWifiMicrosoftDriver(String wifiMicrosoftDriver) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.wifiMicrosoftDriver = wifiMicrosoftDriver;
        return _x;
    }

    @Property(name="wifiMicrosoftDriverVersion")
    @JsonIgnore
    public Optional<String> getWifiMicrosoftDriverVersion() {
        return Optional.ofNullable(wifiMicrosoftDriverVersion);
    }

    public NetworkInfo withWifiMicrosoftDriverVersion(String wifiMicrosoftDriverVersion) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.wifiMicrosoftDriverVersion = wifiMicrosoftDriverVersion;
        return _x;
    }

    @Property(name="wifiVendorDriver")
    @JsonIgnore
    public Optional<String> getWifiVendorDriver() {
        return Optional.ofNullable(wifiVendorDriver);
    }

    public NetworkInfo withWifiVendorDriver(String wifiVendorDriver) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.wifiVendorDriver = wifiVendorDriver;
        return _x;
    }

    @Property(name="wifiVendorDriverVersion")
    @JsonIgnore
    public Optional<String> getWifiVendorDriverVersion() {
        return Optional.ofNullable(wifiVendorDriverVersion);
    }

    public NetworkInfo withWifiVendorDriverVersion(String wifiVendorDriverVersion) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.wifiVendorDriverVersion = wifiVendorDriverVersion;
        return _x;
    }

    @Property(name="wifiChannel")
    @JsonIgnore
    public Optional<Integer> getWifiChannel() {
        return Optional.ofNullable(wifiChannel);
    }

    public NetworkInfo withWifiChannel(Integer wifiChannel) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.wifiChannel = wifiChannel;
        return _x;
    }

    @Property(name="wifiBand")
    @JsonIgnore
    public Optional<WifiBand> getWifiBand() {
        return Optional.ofNullable(wifiBand);
    }

    public NetworkInfo withWifiBand(WifiBand wifiBand) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.wifiBand = wifiBand;
        return _x;
    }

    @Property(name="basicServiceSetIdentifier")
    @JsonIgnore
    public Optional<String> getBasicServiceSetIdentifier() {
        return Optional.ofNullable(basicServiceSetIdentifier);
    }

    public NetworkInfo withBasicServiceSetIdentifier(String basicServiceSetIdentifier) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.basicServiceSetIdentifier = basicServiceSetIdentifier;
        return _x;
    }

    @Property(name="wifiRadioType")
    @JsonIgnore
    public Optional<WifiRadioType> getWifiRadioType() {
        return Optional.ofNullable(wifiRadioType);
    }

    public NetworkInfo withWifiRadioType(WifiRadioType wifiRadioType) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.wifiRadioType = wifiRadioType;
        return _x;
    }

    @Property(name="wifiSignalStrength")
    @JsonIgnore
    public Optional<Integer> getWifiSignalStrength() {
        return Optional.ofNullable(wifiSignalStrength);
    }

    public NetworkInfo withWifiSignalStrength(Integer wifiSignalStrength) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.wifiSignalStrength = wifiSignalStrength;
        return _x;
    }

    @Property(name="wifiBatteryCharge")
    @JsonIgnore
    public Optional<Integer> getWifiBatteryCharge() {
        return Optional.ofNullable(wifiBatteryCharge);
    }

    public NetworkInfo withWifiBatteryCharge(Integer wifiBatteryCharge) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.wifiBatteryCharge = wifiBatteryCharge;
        return _x;
    }

    @Property(name="dnsSuffix")
    @JsonIgnore
    public Optional<String> getDnsSuffix() {
        return Optional.ofNullable(dnsSuffix);
    }

    public NetworkInfo withDnsSuffix(String dnsSuffix) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.dnsSuffix = dnsSuffix;
        return _x;
    }

    @Property(name="sentQualityEventRatio")
    @JsonIgnore
    public Optional<Float> getSentQualityEventRatio() {
        return Optional.ofNullable(sentQualityEventRatio);
    }

    public NetworkInfo withSentQualityEventRatio(Float sentQualityEventRatio) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.sentQualityEventRatio = sentQualityEventRatio;
        return _x;
    }

    @Property(name="receivedQualityEventRatio")
    @JsonIgnore
    public Optional<Float> getReceivedQualityEventRatio() {
        return Optional.ofNullable(receivedQualityEventRatio);
    }

    public NetworkInfo withReceivedQualityEventRatio(Float receivedQualityEventRatio) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.receivedQualityEventRatio = receivedQualityEventRatio;
        return _x;
    }

    @Property(name="delayEventRatio")
    @JsonIgnore
    public Optional<Float> getDelayEventRatio() {
        return Optional.ofNullable(delayEventRatio);
    }

    public NetworkInfo withDelayEventRatio(Float delayEventRatio) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.delayEventRatio = delayEventRatio;
        return _x;
    }

    @Property(name="bandwidthLowEventRatio")
    @JsonIgnore
    public Optional<Float> getBandwidthLowEventRatio() {
        return Optional.ofNullable(bandwidthLowEventRatio);
    }

    public NetworkInfo withBandwidthLowEventRatio(Float bandwidthLowEventRatio) {
        NetworkInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.networkInfo");
        _x.bandwidthLowEventRatio = bandwidthLowEventRatio;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String ipAddress;
        private String subnet;
        private Long linkSpeed;
        private NetworkConnectionType connectionType;
        private Integer port;
        private String reflexiveIPAddress;
        private String relayIPAddress;
        private Integer relayPort;
        private String macAddress;
        private String wifiMicrosoftDriver;
        private String wifiMicrosoftDriverVersion;
        private String wifiVendorDriver;
        private String wifiVendorDriverVersion;
        private Integer wifiChannel;
        private WifiBand wifiBand;
        private String basicServiceSetIdentifier;
        private WifiRadioType wifiRadioType;
        private Integer wifiSignalStrength;
        private Integer wifiBatteryCharge;
        private String dnsSuffix;
        private Float sentQualityEventRatio;
        private Float receivedQualityEventRatio;
        private Float delayEventRatio;
        private Float bandwidthLowEventRatio;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.changedFields = changedFields.add("ipAddress");
            return this;
        }

        public Builder subnet(String subnet) {
            this.subnet = subnet;
            this.changedFields = changedFields.add("subnet");
            return this;
        }

        public Builder linkSpeed(Long linkSpeed) {
            this.linkSpeed = linkSpeed;
            this.changedFields = changedFields.add("linkSpeed");
            return this;
        }

        public Builder connectionType(NetworkConnectionType connectionType) {
            this.connectionType = connectionType;
            this.changedFields = changedFields.add("connectionType");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.changedFields = changedFields.add("port");
            return this;
        }

        public Builder reflexiveIPAddress(String reflexiveIPAddress) {
            this.reflexiveIPAddress = reflexiveIPAddress;
            this.changedFields = changedFields.add("reflexiveIPAddress");
            return this;
        }

        public Builder relayIPAddress(String relayIPAddress) {
            this.relayIPAddress = relayIPAddress;
            this.changedFields = changedFields.add("relayIPAddress");
            return this;
        }

        public Builder relayPort(Integer relayPort) {
            this.relayPort = relayPort;
            this.changedFields = changedFields.add("relayPort");
            return this;
        }

        public Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            this.changedFields = changedFields.add("macAddress");
            return this;
        }

        public Builder wifiMicrosoftDriver(String wifiMicrosoftDriver) {
            this.wifiMicrosoftDriver = wifiMicrosoftDriver;
            this.changedFields = changedFields.add("wifiMicrosoftDriver");
            return this;
        }

        public Builder wifiMicrosoftDriverVersion(String wifiMicrosoftDriverVersion) {
            this.wifiMicrosoftDriverVersion = wifiMicrosoftDriverVersion;
            this.changedFields = changedFields.add("wifiMicrosoftDriverVersion");
            return this;
        }

        public Builder wifiVendorDriver(String wifiVendorDriver) {
            this.wifiVendorDriver = wifiVendorDriver;
            this.changedFields = changedFields.add("wifiVendorDriver");
            return this;
        }

        public Builder wifiVendorDriverVersion(String wifiVendorDriverVersion) {
            this.wifiVendorDriverVersion = wifiVendorDriverVersion;
            this.changedFields = changedFields.add("wifiVendorDriverVersion");
            return this;
        }

        public Builder wifiChannel(Integer wifiChannel) {
            this.wifiChannel = wifiChannel;
            this.changedFields = changedFields.add("wifiChannel");
            return this;
        }

        public Builder wifiBand(WifiBand wifiBand) {
            this.wifiBand = wifiBand;
            this.changedFields = changedFields.add("wifiBand");
            return this;
        }

        public Builder basicServiceSetIdentifier(String basicServiceSetIdentifier) {
            this.basicServiceSetIdentifier = basicServiceSetIdentifier;
            this.changedFields = changedFields.add("basicServiceSetIdentifier");
            return this;
        }

        public Builder wifiRadioType(WifiRadioType wifiRadioType) {
            this.wifiRadioType = wifiRadioType;
            this.changedFields = changedFields.add("wifiRadioType");
            return this;
        }

        public Builder wifiSignalStrength(Integer wifiSignalStrength) {
            this.wifiSignalStrength = wifiSignalStrength;
            this.changedFields = changedFields.add("wifiSignalStrength");
            return this;
        }

        public Builder wifiBatteryCharge(Integer wifiBatteryCharge) {
            this.wifiBatteryCharge = wifiBatteryCharge;
            this.changedFields = changedFields.add("wifiBatteryCharge");
            return this;
        }

        public Builder dnsSuffix(String dnsSuffix) {
            this.dnsSuffix = dnsSuffix;
            this.changedFields = changedFields.add("dnsSuffix");
            return this;
        }

        public Builder sentQualityEventRatio(Float sentQualityEventRatio) {
            this.sentQualityEventRatio = sentQualityEventRatio;
            this.changedFields = changedFields.add("sentQualityEventRatio");
            return this;
        }

        public Builder receivedQualityEventRatio(Float receivedQualityEventRatio) {
            this.receivedQualityEventRatio = receivedQualityEventRatio;
            this.changedFields = changedFields.add("receivedQualityEventRatio");
            return this;
        }

        public Builder delayEventRatio(Float delayEventRatio) {
            this.delayEventRatio = delayEventRatio;
            this.changedFields = changedFields.add("delayEventRatio");
            return this;
        }

        public Builder bandwidthLowEventRatio(Float bandwidthLowEventRatio) {
            this.bandwidthLowEventRatio = bandwidthLowEventRatio;
            this.changedFields = changedFields.add("bandwidthLowEventRatio");
            return this;
        }

        public NetworkInfo build() {
            NetworkInfo _x = new NetworkInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.callRecords.networkInfo";
            _x.ipAddress = ipAddress;
            _x.subnet = subnet;
            _x.linkSpeed = linkSpeed;
            _x.connectionType = connectionType;
            _x.port = port;
            _x.reflexiveIPAddress = reflexiveIPAddress;
            _x.relayIPAddress = relayIPAddress;
            _x.relayPort = relayPort;
            _x.macAddress = macAddress;
            _x.wifiMicrosoftDriver = wifiMicrosoftDriver;
            _x.wifiMicrosoftDriverVersion = wifiMicrosoftDriverVersion;
            _x.wifiVendorDriver = wifiVendorDriver;
            _x.wifiVendorDriverVersion = wifiVendorDriverVersion;
            _x.wifiChannel = wifiChannel;
            _x.wifiBand = wifiBand;
            _x.basicServiceSetIdentifier = basicServiceSetIdentifier;
            _x.wifiRadioType = wifiRadioType;
            _x.wifiSignalStrength = wifiSignalStrength;
            _x.wifiBatteryCharge = wifiBatteryCharge;
            _x.dnsSuffix = dnsSuffix;
            _x.sentQualityEventRatio = sentQualityEventRatio;
            _x.receivedQualityEventRatio = receivedQualityEventRatio;
            _x.delayEventRatio = delayEventRatio;
            _x.bandwidthLowEventRatio = bandwidthLowEventRatio;
            return _x;
        }
    }

    private NetworkInfo _copy() {
        NetworkInfo _x = new NetworkInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.ipAddress = ipAddress;
        _x.subnet = subnet;
        _x.linkSpeed = linkSpeed;
        _x.connectionType = connectionType;
        _x.port = port;
        _x.reflexiveIPAddress = reflexiveIPAddress;
        _x.relayIPAddress = relayIPAddress;
        _x.relayPort = relayPort;
        _x.macAddress = macAddress;
        _x.wifiMicrosoftDriver = wifiMicrosoftDriver;
        _x.wifiMicrosoftDriverVersion = wifiMicrosoftDriverVersion;
        _x.wifiVendorDriver = wifiVendorDriver;
        _x.wifiVendorDriverVersion = wifiVendorDriverVersion;
        _x.wifiChannel = wifiChannel;
        _x.wifiBand = wifiBand;
        _x.basicServiceSetIdentifier = basicServiceSetIdentifier;
        _x.wifiRadioType = wifiRadioType;
        _x.wifiSignalStrength = wifiSignalStrength;
        _x.wifiBatteryCharge = wifiBatteryCharge;
        _x.dnsSuffix = dnsSuffix;
        _x.sentQualityEventRatio = sentQualityEventRatio;
        _x.receivedQualityEventRatio = receivedQualityEventRatio;
        _x.delayEventRatio = delayEventRatio;
        _x.bandwidthLowEventRatio = bandwidthLowEventRatio;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NetworkInfo[");
        b.append("ipAddress=");
        b.append(this.ipAddress);
        b.append(", ");
        b.append("subnet=");
        b.append(this.subnet);
        b.append(", ");
        b.append("linkSpeed=");
        b.append(this.linkSpeed);
        b.append(", ");
        b.append("connectionType=");
        b.append(this.connectionType);
        b.append(", ");
        b.append("port=");
        b.append(this.port);
        b.append(", ");
        b.append("reflexiveIPAddress=");
        b.append(this.reflexiveIPAddress);
        b.append(", ");
        b.append("relayIPAddress=");
        b.append(this.relayIPAddress);
        b.append(", ");
        b.append("relayPort=");
        b.append(this.relayPort);
        b.append(", ");
        b.append("macAddress=");
        b.append(this.macAddress);
        b.append(", ");
        b.append("wifiMicrosoftDriver=");
        b.append(this.wifiMicrosoftDriver);
        b.append(", ");
        b.append("wifiMicrosoftDriverVersion=");
        b.append(this.wifiMicrosoftDriverVersion);
        b.append(", ");
        b.append("wifiVendorDriver=");
        b.append(this.wifiVendorDriver);
        b.append(", ");
        b.append("wifiVendorDriverVersion=");
        b.append(this.wifiVendorDriverVersion);
        b.append(", ");
        b.append("wifiChannel=");
        b.append(this.wifiChannel);
        b.append(", ");
        b.append("wifiBand=");
        b.append(this.wifiBand);
        b.append(", ");
        b.append("basicServiceSetIdentifier=");
        b.append(this.basicServiceSetIdentifier);
        b.append(", ");
        b.append("wifiRadioType=");
        b.append(this.wifiRadioType);
        b.append(", ");
        b.append("wifiSignalStrength=");
        b.append(this.wifiSignalStrength);
        b.append(", ");
        b.append("wifiBatteryCharge=");
        b.append(this.wifiBatteryCharge);
        b.append(", ");
        b.append("dnsSuffix=");
        b.append(this.dnsSuffix);
        b.append(", ");
        b.append("sentQualityEventRatio=");
        b.append(this.sentQualityEventRatio);
        b.append(", ");
        b.append("receivedQualityEventRatio=");
        b.append(this.receivedQualityEventRatio);
        b.append(", ");
        b.append("delayEventRatio=");
        b.append(this.delayEventRatio);
        b.append(", ");
        b.append("bandwidthLowEventRatio=");
        b.append(this.bandwidthLowEventRatio);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
