package odata.msgraph.client.beta.callRecords.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.callRecords.enums.FailureStage;

@JsonPropertyOrder({
    "@odata.type", 
    "stage", 
    "reason"})
@JsonInclude(Include.NON_NULL)
public class FailureInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("stage")
    protected FailureStage stage;

    @JsonProperty("reason")
    protected String reason;

    protected FailureInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRecords.failureInfo";
    }

    @Property(name="stage")
    @JsonIgnore
    public Optional<FailureStage> getStage() {
        return Optional.ofNullable(stage);
    }

    public FailureInfo withStage(FailureStage stage) {
        FailureInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.failureInfo");
        _x.stage = stage;
        return _x;
    }

    @Property(name="reason")
    @JsonIgnore
    public Optional<String> getReason() {
        return Optional.ofNullable(reason);
    }

    public FailureInfo withReason(String reason) {
        FailureInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.failureInfo");
        _x.reason = reason;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private FailureStage stage;
        private String reason;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder stage(FailureStage stage) {
            this.stage = stage;
            this.changedFields = changedFields.add("stage");
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            this.changedFields = changedFields.add("reason");
            return this;
        }

        public FailureInfo build() {
            FailureInfo _x = new FailureInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.callRecords.failureInfo";
            _x.stage = stage;
            _x.reason = reason;
            return _x;
        }
    }

    private FailureInfo _copy() {
        FailureInfo _x = new FailureInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.stage = stage;
        _x.reason = reason;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FailureInfo[");
        b.append("stage=");
        b.append(this.stage);
        b.append(", ");
        b.append("reason=");
        b.append(this.reason);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
