package odata.msgraph.client.beta.callRecords.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "captureDeviceName", 
    "captureDeviceDriver", 
    "renderDeviceName", 
    "renderDeviceDriver", 
    "sentSignalLevel", 
    "receivedSignalLevel", 
    "sentNoiseLevel", 
    "receivedNoiseLevel", 
    "initialSignalLevelRootMeanSquare", 
    "cpuInsufficentEventRatio", 
    "renderNotFunctioningEventRatio", 
    "captureNotFunctioningEventRatio", 
    "deviceGlitchEventRatio", 
    "lowSpeechToNoiseEventRatio", 
    "lowSpeechLevelEventRatio", 
    "deviceClippingEventRatio", 
    "howlingEventCount", 
    "renderZeroVolumeEventRatio", 
    "renderMuteEventRatio", 
    "micGlitchRate", 
    "speakerGlitchRate"})
@JsonInclude(Include.NON_NULL)
public class DeviceInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("captureDeviceName")
    protected String captureDeviceName;

    @JsonProperty("captureDeviceDriver")
    protected String captureDeviceDriver;

    @JsonProperty("renderDeviceName")
    protected String renderDeviceName;

    @JsonProperty("renderDeviceDriver")
    protected String renderDeviceDriver;

    @JsonProperty("sentSignalLevel")
    protected Integer sentSignalLevel;

    @JsonProperty("receivedSignalLevel")
    protected Integer receivedSignalLevel;

    @JsonProperty("sentNoiseLevel")
    protected Integer sentNoiseLevel;

    @JsonProperty("receivedNoiseLevel")
    protected Integer receivedNoiseLevel;

    @JsonProperty("initialSignalLevelRootMeanSquare")
    protected Float initialSignalLevelRootMeanSquare;

    @JsonProperty("cpuInsufficentEventRatio")
    protected Float cpuInsufficentEventRatio;

    @JsonProperty("renderNotFunctioningEventRatio")
    protected Float renderNotFunctioningEventRatio;

    @JsonProperty("captureNotFunctioningEventRatio")
    protected Float captureNotFunctioningEventRatio;

    @JsonProperty("deviceGlitchEventRatio")
    protected Float deviceGlitchEventRatio;

    @JsonProperty("lowSpeechToNoiseEventRatio")
    protected Float lowSpeechToNoiseEventRatio;

    @JsonProperty("lowSpeechLevelEventRatio")
    protected Float lowSpeechLevelEventRatio;

    @JsonProperty("deviceClippingEventRatio")
    protected Float deviceClippingEventRatio;

    @JsonProperty("howlingEventCount")
    protected Integer howlingEventCount;

    @JsonProperty("renderZeroVolumeEventRatio")
    protected Float renderZeroVolumeEventRatio;

    @JsonProperty("renderMuteEventRatio")
    protected Float renderMuteEventRatio;

    @JsonProperty("micGlitchRate")
    protected Float micGlitchRate;

    @JsonProperty("speakerGlitchRate")
    protected Float speakerGlitchRate;

    protected DeviceInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRecords.deviceInfo";
    }

    @Property(name="captureDeviceName")
    @JsonIgnore
    public Optional<String> getCaptureDeviceName() {
        return Optional.ofNullable(captureDeviceName);
    }

    public DeviceInfo withCaptureDeviceName(String captureDeviceName) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.captureDeviceName = captureDeviceName;
        return _x;
    }

    @Property(name="captureDeviceDriver")
    @JsonIgnore
    public Optional<String> getCaptureDeviceDriver() {
        return Optional.ofNullable(captureDeviceDriver);
    }

    public DeviceInfo withCaptureDeviceDriver(String captureDeviceDriver) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.captureDeviceDriver = captureDeviceDriver;
        return _x;
    }

    @Property(name="renderDeviceName")
    @JsonIgnore
    public Optional<String> getRenderDeviceName() {
        return Optional.ofNullable(renderDeviceName);
    }

    public DeviceInfo withRenderDeviceName(String renderDeviceName) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.renderDeviceName = renderDeviceName;
        return _x;
    }

    @Property(name="renderDeviceDriver")
    @JsonIgnore
    public Optional<String> getRenderDeviceDriver() {
        return Optional.ofNullable(renderDeviceDriver);
    }

    public DeviceInfo withRenderDeviceDriver(String renderDeviceDriver) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.renderDeviceDriver = renderDeviceDriver;
        return _x;
    }

    @Property(name="sentSignalLevel")
    @JsonIgnore
    public Optional<Integer> getSentSignalLevel() {
        return Optional.ofNullable(sentSignalLevel);
    }

    public DeviceInfo withSentSignalLevel(Integer sentSignalLevel) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.sentSignalLevel = sentSignalLevel;
        return _x;
    }

    @Property(name="receivedSignalLevel")
    @JsonIgnore
    public Optional<Integer> getReceivedSignalLevel() {
        return Optional.ofNullable(receivedSignalLevel);
    }

    public DeviceInfo withReceivedSignalLevel(Integer receivedSignalLevel) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.receivedSignalLevel = receivedSignalLevel;
        return _x;
    }

    @Property(name="sentNoiseLevel")
    @JsonIgnore
    public Optional<Integer> getSentNoiseLevel() {
        return Optional.ofNullable(sentNoiseLevel);
    }

    public DeviceInfo withSentNoiseLevel(Integer sentNoiseLevel) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.sentNoiseLevel = sentNoiseLevel;
        return _x;
    }

    @Property(name="receivedNoiseLevel")
    @JsonIgnore
    public Optional<Integer> getReceivedNoiseLevel() {
        return Optional.ofNullable(receivedNoiseLevel);
    }

    public DeviceInfo withReceivedNoiseLevel(Integer receivedNoiseLevel) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.receivedNoiseLevel = receivedNoiseLevel;
        return _x;
    }

    @Property(name="initialSignalLevelRootMeanSquare")
    @JsonIgnore
    public Optional<Float> getInitialSignalLevelRootMeanSquare() {
        return Optional.ofNullable(initialSignalLevelRootMeanSquare);
    }

    public DeviceInfo withInitialSignalLevelRootMeanSquare(Float initialSignalLevelRootMeanSquare) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.initialSignalLevelRootMeanSquare = initialSignalLevelRootMeanSquare;
        return _x;
    }

    @Property(name="cpuInsufficentEventRatio")
    @JsonIgnore
    public Optional<Float> getCpuInsufficentEventRatio() {
        return Optional.ofNullable(cpuInsufficentEventRatio);
    }

    public DeviceInfo withCpuInsufficentEventRatio(Float cpuInsufficentEventRatio) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.cpuInsufficentEventRatio = cpuInsufficentEventRatio;
        return _x;
    }

    @Property(name="renderNotFunctioningEventRatio")
    @JsonIgnore
    public Optional<Float> getRenderNotFunctioningEventRatio() {
        return Optional.ofNullable(renderNotFunctioningEventRatio);
    }

    public DeviceInfo withRenderNotFunctioningEventRatio(Float renderNotFunctioningEventRatio) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.renderNotFunctioningEventRatio = renderNotFunctioningEventRatio;
        return _x;
    }

    @Property(name="captureNotFunctioningEventRatio")
    @JsonIgnore
    public Optional<Float> getCaptureNotFunctioningEventRatio() {
        return Optional.ofNullable(captureNotFunctioningEventRatio);
    }

    public DeviceInfo withCaptureNotFunctioningEventRatio(Float captureNotFunctioningEventRatio) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.captureNotFunctioningEventRatio = captureNotFunctioningEventRatio;
        return _x;
    }

    @Property(name="deviceGlitchEventRatio")
    @JsonIgnore
    public Optional<Float> getDeviceGlitchEventRatio() {
        return Optional.ofNullable(deviceGlitchEventRatio);
    }

    public DeviceInfo withDeviceGlitchEventRatio(Float deviceGlitchEventRatio) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.deviceGlitchEventRatio = deviceGlitchEventRatio;
        return _x;
    }

    @Property(name="lowSpeechToNoiseEventRatio")
    @JsonIgnore
    public Optional<Float> getLowSpeechToNoiseEventRatio() {
        return Optional.ofNullable(lowSpeechToNoiseEventRatio);
    }

    public DeviceInfo withLowSpeechToNoiseEventRatio(Float lowSpeechToNoiseEventRatio) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.lowSpeechToNoiseEventRatio = lowSpeechToNoiseEventRatio;
        return _x;
    }

    @Property(name="lowSpeechLevelEventRatio")
    @JsonIgnore
    public Optional<Float> getLowSpeechLevelEventRatio() {
        return Optional.ofNullable(lowSpeechLevelEventRatio);
    }

    public DeviceInfo withLowSpeechLevelEventRatio(Float lowSpeechLevelEventRatio) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.lowSpeechLevelEventRatio = lowSpeechLevelEventRatio;
        return _x;
    }

    @Property(name="deviceClippingEventRatio")
    @JsonIgnore
    public Optional<Float> getDeviceClippingEventRatio() {
        return Optional.ofNullable(deviceClippingEventRatio);
    }

    public DeviceInfo withDeviceClippingEventRatio(Float deviceClippingEventRatio) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.deviceClippingEventRatio = deviceClippingEventRatio;
        return _x;
    }

    @Property(name="howlingEventCount")
    @JsonIgnore
    public Optional<Integer> getHowlingEventCount() {
        return Optional.ofNullable(howlingEventCount);
    }

    public DeviceInfo withHowlingEventCount(Integer howlingEventCount) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.howlingEventCount = howlingEventCount;
        return _x;
    }

    @Property(name="renderZeroVolumeEventRatio")
    @JsonIgnore
    public Optional<Float> getRenderZeroVolumeEventRatio() {
        return Optional.ofNullable(renderZeroVolumeEventRatio);
    }

    public DeviceInfo withRenderZeroVolumeEventRatio(Float renderZeroVolumeEventRatio) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.renderZeroVolumeEventRatio = renderZeroVolumeEventRatio;
        return _x;
    }

    @Property(name="renderMuteEventRatio")
    @JsonIgnore
    public Optional<Float> getRenderMuteEventRatio() {
        return Optional.ofNullable(renderMuteEventRatio);
    }

    public DeviceInfo withRenderMuteEventRatio(Float renderMuteEventRatio) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.renderMuteEventRatio = renderMuteEventRatio;
        return _x;
    }

    @Property(name="micGlitchRate")
    @JsonIgnore
    public Optional<Float> getMicGlitchRate() {
        return Optional.ofNullable(micGlitchRate);
    }

    public DeviceInfo withMicGlitchRate(Float micGlitchRate) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.micGlitchRate = micGlitchRate;
        return _x;
    }

    @Property(name="speakerGlitchRate")
    @JsonIgnore
    public Optional<Float> getSpeakerGlitchRate() {
        return Optional.ofNullable(speakerGlitchRate);
    }

    public DeviceInfo withSpeakerGlitchRate(Float speakerGlitchRate) {
        DeviceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.deviceInfo");
        _x.speakerGlitchRate = speakerGlitchRate;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String captureDeviceName;
        private String captureDeviceDriver;
        private String renderDeviceName;
        private String renderDeviceDriver;
        private Integer sentSignalLevel;
        private Integer receivedSignalLevel;
        private Integer sentNoiseLevel;
        private Integer receivedNoiseLevel;
        private Float initialSignalLevelRootMeanSquare;
        private Float cpuInsufficentEventRatio;
        private Float renderNotFunctioningEventRatio;
        private Float captureNotFunctioningEventRatio;
        private Float deviceGlitchEventRatio;
        private Float lowSpeechToNoiseEventRatio;
        private Float lowSpeechLevelEventRatio;
        private Float deviceClippingEventRatio;
        private Integer howlingEventCount;
        private Float renderZeroVolumeEventRatio;
        private Float renderMuteEventRatio;
        private Float micGlitchRate;
        private Float speakerGlitchRate;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder captureDeviceName(String captureDeviceName) {
            this.captureDeviceName = captureDeviceName;
            this.changedFields = changedFields.add("captureDeviceName");
            return this;
        }

        public Builder captureDeviceDriver(String captureDeviceDriver) {
            this.captureDeviceDriver = captureDeviceDriver;
            this.changedFields = changedFields.add("captureDeviceDriver");
            return this;
        }

        public Builder renderDeviceName(String renderDeviceName) {
            this.renderDeviceName = renderDeviceName;
            this.changedFields = changedFields.add("renderDeviceName");
            return this;
        }

        public Builder renderDeviceDriver(String renderDeviceDriver) {
            this.renderDeviceDriver = renderDeviceDriver;
            this.changedFields = changedFields.add("renderDeviceDriver");
            return this;
        }

        public Builder sentSignalLevel(Integer sentSignalLevel) {
            this.sentSignalLevel = sentSignalLevel;
            this.changedFields = changedFields.add("sentSignalLevel");
            return this;
        }

        public Builder receivedSignalLevel(Integer receivedSignalLevel) {
            this.receivedSignalLevel = receivedSignalLevel;
            this.changedFields = changedFields.add("receivedSignalLevel");
            return this;
        }

        public Builder sentNoiseLevel(Integer sentNoiseLevel) {
            this.sentNoiseLevel = sentNoiseLevel;
            this.changedFields = changedFields.add("sentNoiseLevel");
            return this;
        }

        public Builder receivedNoiseLevel(Integer receivedNoiseLevel) {
            this.receivedNoiseLevel = receivedNoiseLevel;
            this.changedFields = changedFields.add("receivedNoiseLevel");
            return this;
        }

        public Builder initialSignalLevelRootMeanSquare(Float initialSignalLevelRootMeanSquare) {
            this.initialSignalLevelRootMeanSquare = initialSignalLevelRootMeanSquare;
            this.changedFields = changedFields.add("initialSignalLevelRootMeanSquare");
            return this;
        }

        public Builder cpuInsufficentEventRatio(Float cpuInsufficentEventRatio) {
            this.cpuInsufficentEventRatio = cpuInsufficentEventRatio;
            this.changedFields = changedFields.add("cpuInsufficentEventRatio");
            return this;
        }

        public Builder renderNotFunctioningEventRatio(Float renderNotFunctioningEventRatio) {
            this.renderNotFunctioningEventRatio = renderNotFunctioningEventRatio;
            this.changedFields = changedFields.add("renderNotFunctioningEventRatio");
            return this;
        }

        public Builder captureNotFunctioningEventRatio(Float captureNotFunctioningEventRatio) {
            this.captureNotFunctioningEventRatio = captureNotFunctioningEventRatio;
            this.changedFields = changedFields.add("captureNotFunctioningEventRatio");
            return this;
        }

        public Builder deviceGlitchEventRatio(Float deviceGlitchEventRatio) {
            this.deviceGlitchEventRatio = deviceGlitchEventRatio;
            this.changedFields = changedFields.add("deviceGlitchEventRatio");
            return this;
        }

        public Builder lowSpeechToNoiseEventRatio(Float lowSpeechToNoiseEventRatio) {
            this.lowSpeechToNoiseEventRatio = lowSpeechToNoiseEventRatio;
            this.changedFields = changedFields.add("lowSpeechToNoiseEventRatio");
            return this;
        }

        public Builder lowSpeechLevelEventRatio(Float lowSpeechLevelEventRatio) {
            this.lowSpeechLevelEventRatio = lowSpeechLevelEventRatio;
            this.changedFields = changedFields.add("lowSpeechLevelEventRatio");
            return this;
        }

        public Builder deviceClippingEventRatio(Float deviceClippingEventRatio) {
            this.deviceClippingEventRatio = deviceClippingEventRatio;
            this.changedFields = changedFields.add("deviceClippingEventRatio");
            return this;
        }

        public Builder howlingEventCount(Integer howlingEventCount) {
            this.howlingEventCount = howlingEventCount;
            this.changedFields = changedFields.add("howlingEventCount");
            return this;
        }

        public Builder renderZeroVolumeEventRatio(Float renderZeroVolumeEventRatio) {
            this.renderZeroVolumeEventRatio = renderZeroVolumeEventRatio;
            this.changedFields = changedFields.add("renderZeroVolumeEventRatio");
            return this;
        }

        public Builder renderMuteEventRatio(Float renderMuteEventRatio) {
            this.renderMuteEventRatio = renderMuteEventRatio;
            this.changedFields = changedFields.add("renderMuteEventRatio");
            return this;
        }

        public Builder micGlitchRate(Float micGlitchRate) {
            this.micGlitchRate = micGlitchRate;
            this.changedFields = changedFields.add("micGlitchRate");
            return this;
        }

        public Builder speakerGlitchRate(Float speakerGlitchRate) {
            this.speakerGlitchRate = speakerGlitchRate;
            this.changedFields = changedFields.add("speakerGlitchRate");
            return this;
        }

        public DeviceInfo build() {
            DeviceInfo _x = new DeviceInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.callRecords.deviceInfo";
            _x.captureDeviceName = captureDeviceName;
            _x.captureDeviceDriver = captureDeviceDriver;
            _x.renderDeviceName = renderDeviceName;
            _x.renderDeviceDriver = renderDeviceDriver;
            _x.sentSignalLevel = sentSignalLevel;
            _x.receivedSignalLevel = receivedSignalLevel;
            _x.sentNoiseLevel = sentNoiseLevel;
            _x.receivedNoiseLevel = receivedNoiseLevel;
            _x.initialSignalLevelRootMeanSquare = initialSignalLevelRootMeanSquare;
            _x.cpuInsufficentEventRatio = cpuInsufficentEventRatio;
            _x.renderNotFunctioningEventRatio = renderNotFunctioningEventRatio;
            _x.captureNotFunctioningEventRatio = captureNotFunctioningEventRatio;
            _x.deviceGlitchEventRatio = deviceGlitchEventRatio;
            _x.lowSpeechToNoiseEventRatio = lowSpeechToNoiseEventRatio;
            _x.lowSpeechLevelEventRatio = lowSpeechLevelEventRatio;
            _x.deviceClippingEventRatio = deviceClippingEventRatio;
            _x.howlingEventCount = howlingEventCount;
            _x.renderZeroVolumeEventRatio = renderZeroVolumeEventRatio;
            _x.renderMuteEventRatio = renderMuteEventRatio;
            _x.micGlitchRate = micGlitchRate;
            _x.speakerGlitchRate = speakerGlitchRate;
            return _x;
        }
    }

    private DeviceInfo _copy() {
        DeviceInfo _x = new DeviceInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.captureDeviceName = captureDeviceName;
        _x.captureDeviceDriver = captureDeviceDriver;
        _x.renderDeviceName = renderDeviceName;
        _x.renderDeviceDriver = renderDeviceDriver;
        _x.sentSignalLevel = sentSignalLevel;
        _x.receivedSignalLevel = receivedSignalLevel;
        _x.sentNoiseLevel = sentNoiseLevel;
        _x.receivedNoiseLevel = receivedNoiseLevel;
        _x.initialSignalLevelRootMeanSquare = initialSignalLevelRootMeanSquare;
        _x.cpuInsufficentEventRatio = cpuInsufficentEventRatio;
        _x.renderNotFunctioningEventRatio = renderNotFunctioningEventRatio;
        _x.captureNotFunctioningEventRatio = captureNotFunctioningEventRatio;
        _x.deviceGlitchEventRatio = deviceGlitchEventRatio;
        _x.lowSpeechToNoiseEventRatio = lowSpeechToNoiseEventRatio;
        _x.lowSpeechLevelEventRatio = lowSpeechLevelEventRatio;
        _x.deviceClippingEventRatio = deviceClippingEventRatio;
        _x.howlingEventCount = howlingEventCount;
        _x.renderZeroVolumeEventRatio = renderZeroVolumeEventRatio;
        _x.renderMuteEventRatio = renderMuteEventRatio;
        _x.micGlitchRate = micGlitchRate;
        _x.speakerGlitchRate = speakerGlitchRate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceInfo[");
        b.append("captureDeviceName=");
        b.append(this.captureDeviceName);
        b.append(", ");
        b.append("captureDeviceDriver=");
        b.append(this.captureDeviceDriver);
        b.append(", ");
        b.append("renderDeviceName=");
        b.append(this.renderDeviceName);
        b.append(", ");
        b.append("renderDeviceDriver=");
        b.append(this.renderDeviceDriver);
        b.append(", ");
        b.append("sentSignalLevel=");
        b.append(this.sentSignalLevel);
        b.append(", ");
        b.append("receivedSignalLevel=");
        b.append(this.receivedSignalLevel);
        b.append(", ");
        b.append("sentNoiseLevel=");
        b.append(this.sentNoiseLevel);
        b.append(", ");
        b.append("receivedNoiseLevel=");
        b.append(this.receivedNoiseLevel);
        b.append(", ");
        b.append("initialSignalLevelRootMeanSquare=");
        b.append(this.initialSignalLevelRootMeanSquare);
        b.append(", ");
        b.append("cpuInsufficentEventRatio=");
        b.append(this.cpuInsufficentEventRatio);
        b.append(", ");
        b.append("renderNotFunctioningEventRatio=");
        b.append(this.renderNotFunctioningEventRatio);
        b.append(", ");
        b.append("captureNotFunctioningEventRatio=");
        b.append(this.captureNotFunctioningEventRatio);
        b.append(", ");
        b.append("deviceGlitchEventRatio=");
        b.append(this.deviceGlitchEventRatio);
        b.append(", ");
        b.append("lowSpeechToNoiseEventRatio=");
        b.append(this.lowSpeechToNoiseEventRatio);
        b.append(", ");
        b.append("lowSpeechLevelEventRatio=");
        b.append(this.lowSpeechLevelEventRatio);
        b.append(", ");
        b.append("deviceClippingEventRatio=");
        b.append(this.deviceClippingEventRatio);
        b.append(", ");
        b.append("howlingEventCount=");
        b.append(this.howlingEventCount);
        b.append(", ");
        b.append("renderZeroVolumeEventRatio=");
        b.append(this.renderZeroVolumeEventRatio);
        b.append(", ");
        b.append("renderMuteEventRatio=");
        b.append(this.renderMuteEventRatio);
        b.append(", ");
        b.append("micGlitchRate=");
        b.append(this.micGlitchRate);
        b.append(", ");
        b.append("speakerGlitchRate=");
        b.append(this.speakerGlitchRate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
