package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum XrmAggregateType implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Count")
    COUNT("Count", "1"),

    @JsonProperty("CountColumn")
    COUNT_COLUMN("CountColumn", "2"),

    @JsonProperty("Sum")
    SUM("Sum", "3"),

    @JsonProperty("Avg")
    AVG("Avg", "4"),

    @JsonProperty("Min")
    MIN("Min", "5"),

    @JsonProperty("Max")
    MAX("Max", "6");

    private final String name;
    private final String value;

    private XrmAggregateType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
