package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum OrganizationType implements Enum {

    @JsonProperty("Customer")
    CUSTOMER("Customer", "0"),

    @JsonProperty("Monitoring")
    MONITORING("Monitoring", "1"),

    @JsonProperty("Support")
    SUPPORT("Support", "2"),

    @JsonProperty("BackEnd")
    BACK_END("BackEnd", "3"),

    @JsonProperty("Secondary")
    SECONDARY("Secondary", "4"),

    @JsonProperty("CustomerTest")
    CUSTOMER_TEST("CustomerTest", "5"),

    @JsonProperty("CustomerFreeTest")
    CUSTOMER_FREE_TEST("CustomerFreeTest", "6"),

    @JsonProperty("CustomerPreview")
    CUSTOMER_PREVIEW("CustomerPreview", "7"),

    @JsonProperty("Placeholder")
    PLACEHOLDER("Placeholder", "8"),

    @JsonProperty("TestDrive")
    TEST_DRIVE("TestDrive", "9"),

    @JsonProperty("MsftInvestigation")
    MSFT_INVESTIGATION("MsftInvestigation", "10"),

    @JsonProperty("EmailTrial")
    EMAIL_TRIAL("EmailTrial", "11"),

    @JsonProperty("Default")
    DEFAULT("Default", "12"),

    @JsonProperty("Developer")
    DEVELOPER("Developer", "13"),

    @JsonProperty("Trial")
    TRIAL("Trial", "14"),

    @JsonProperty("Teams")
    TEAMS("Teams", "15");

    private final String name;
    private final String value;

    private OrganizationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
