package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum OptionSetType implements Enum {

    @JsonProperty("Picklist")
    PICKLIST("Picklist", "0"),

    @JsonProperty("State")
    STATE("State", "1"),

    @JsonProperty("Status")
    STATUS("Status", "2"),

    @JsonProperty("Boolean")
    BOOLEAN("Boolean", "3");

    private final String name;
    private final String value;

    private OptionSetType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
