package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ChannelAccessProfilePrivilegeDepth implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("EntityReference")
    ENTITY_REFERENCE("EntityReference", "1"),

    @JsonProperty("ParentEntityReference")
    PARENT_ENTITY_REFERENCE("ParentEntityReference", "2"),

    @JsonProperty("Global")
    GLOBAL("Global", "8");

    private final String name;
    private final String value;

    private ChannelAccessProfilePrivilegeDepth(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
