package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum BusinessNotificationParameterType implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("String")
    STRING("String", "1"),

    @JsonProperty("Attribute")
    ATTRIBUTE("Attribute", "2");

    private final String name;
    private final String value;

    private BusinessNotificationParameterType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
