package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Recurringappointmentmaster;
import microsoft.dynamics.crm.entity.collection.request.ActioncardCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypartyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppointmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostfollowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostregardingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class RecurringappointmentmasterRequest extends EntityRequest<Recurringappointmentmaster> {

    public RecurringappointmentmasterRequest(ContextPath contextPath, Optional<Object> value) {
        super(Recurringappointmentmaster.class, contextPath, value, false);
    }

    public PostregardingRequest recurringappointmentmaster_PostRegardings(UUID postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("recurringappointmentmaster_PostRegardings").addKeys(new NameValue(postregardingid, UUID.class)), Optional.empty());
    }

    public PostregardingCollectionRequest recurringappointmentmaster_PostRegardings() {
        return new PostregardingCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_PostRegardings"), Optional.empty());
    }

    public PostfollowRequest recurringappointmentmaster_PostFollows(UUID postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("recurringappointmentmaster_PostFollows").addKeys(new NameValue(postfollowid, UUID.class)), Optional.empty());
    }

    public PostfollowCollectionRequest recurringappointmentmaster_PostFollows() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_PostFollows"), Optional.empty());
    }

    public KnowledgebaserecordRequest regardingobjectid_knowledgebaserecord_recurringappointmentmaster() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("regardingobjectid_knowledgebaserecord_recurringappointmentmaster"), Optional.empty());
    }

    public BulkdeletefailureRequest recurringAppointmentMaster_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("RecurringAppointmentMaster_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest recurringAppointmentMaster_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_BulkDeleteFailures"), Optional.empty());
    }

    public AsyncoperationRequest recurringAppointmentMaster_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("RecurringAppointmentMaster_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest recurringAppointmentMaster_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_AsyncOperations"), Optional.empty());
    }

    public DuplicaterecordRequest recurringAppointmentMaster_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("RecurringAppointmentMaster_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest recurringAppointmentMaster_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_DuplicateBaseRecord"), Optional.empty());
    }

    public SystemuserRequest owninguser_recurringappointmentmaster() {
        return new SystemuserRequest(contextPath.addSegment("owninguser_recurringappointmentmaster"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest recurringappointmentmaster_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("recurringappointmentmaster_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest recurringappointmentmaster_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_principalobjectattributeaccess"), Optional.empty());
    }

    public TeamRequest owningteam_recurringappointmentmaster() {
        return new TeamRequest(contextPath.addSegment("owningteam_recurringappointmentmaster"), Optional.empty());
    }

    public ActivitypointerRequest activityid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("activityid_activitypointer"), Optional.empty());
    }

    public ActivitypartyRequest recurringappointmentmaster_activity_parties(UUID activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("recurringappointmentmaster_activity_parties").addKeys(new NameValue(activitypartyid, UUID.class)), Optional.empty());
    }

    public ActivitypartyCollectionRequest recurringappointmentmaster_activity_parties() {
        return new ActivitypartyCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_activity_parties"), Optional.empty());
    }

    public DuplicaterecordRequest recurringAppointmentMaster_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("RecurringAppointmentMaster_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest recurringAppointmentMaster_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_DuplicateMatchingRecord"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit_recurringappointmentmaster() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit_recurringappointmentmaster"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby_recurringappointmentmaster() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby_recurringappointmentmaster"), Optional.empty());
    }

    public SystemuserRequest createdby_recurringappointmentmaster() {
        return new SystemuserRequest(contextPath.addSegment("createdby_recurringappointmentmaster"), Optional.empty());
    }

    public KnowledgearticleRequest regardingobjectid_knowledgearticle_recurringappointmentmaster() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle_recurringappointmentmaster"), Optional.empty());
    }

    public AppointmentRequest recurringappointmentmaster_appointment(UUID activityid) {
        return new AppointmentRequest(contextPath.addSegment("recurringappointmentmaster_appointment").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public AppointmentCollectionRequest recurringappointmentmaster_appointment() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_appointment"), Optional.empty());
    }

    public AccountRequest regardingobjectid_account_recurringappointmentmaster() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account_recurringappointmentmaster"), Optional.empty());
    }

    public QueueitemRequest recurringAppointmentMaster_QueueItem(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("RecurringAppointmentMaster_QueueItem").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public QueueitemCollectionRequest recurringAppointmentMaster_QueueItem() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_QueueItem"), Optional.empty());
    }

    public ConnectionRequest recurringappointmentmaster_connections1(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("recurringappointmentmaster_connections1").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest recurringappointmentmaster_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_connections1"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby_recurringappointmentmaster() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby_recurringappointmentmaster"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid_recurringappointmentmaster() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid_recurringappointmentmaster"), Optional.empty());
    }

    public ConnectionRequest recurringappointmentmaster_connections2(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("recurringappointmentmaster_connections2").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest recurringappointmentmaster_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_connections2"), Optional.empty());
    }

    public SyncerrorRequest recurringAppointmentMaster_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("RecurringAppointmentMaster_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest recurringAppointmentMaster_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_SyncErrors"), Optional.empty());
    }

    public ProcessstageRequest stageid_processstage() {
        return new ProcessstageRequest(contextPath.addSegment("stageid_processstage"), Optional.empty());
    }

    public ActioncardRequest recurringappointmentmaster_actioncard(UUID actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("recurringappointmentmaster_actioncard").addKeys(new NameValue(actioncardid, UUID.class)), Optional.empty());
    }

    public ActioncardCollectionRequest recurringappointmentmaster_actioncard() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_actioncard"), Optional.empty());
    }

    public ContactRequest regardingobjectid_contact_recurringappointmentmaster() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact_recurringappointmentmaster"), Optional.empty());
    }

    public SystemuserRequest modifiedby_recurringappointmentmaster() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby_recurringappointmentmaster"), Optional.empty());
    }

    public RecurrenceruleRequest activityid_recurrencerule() {
        return new RecurrenceruleRequest(contextPath.addSegment("activityid_recurrencerule"), Optional.empty());
    }

    public ProcesssessionRequest recurringAppointmentMaster_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("RecurringAppointmentMaster_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest recurringAppointmentMaster_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_ProcessSessions"), Optional.empty());
    }

    public AnnotationRequest recurringAppointmentMaster_Annotation(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("RecurringAppointmentMaster_Annotation").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest recurringAppointmentMaster_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_Annotation"), Optional.empty());
    }

    public PrincipalRequest ownerid_recurringappointmentmaster() {
        return new PrincipalRequest(contextPath.addSegment("ownerid_recurringappointmentmaster"), Optional.empty());
    }

}
