package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Phonecall;
import microsoft.dynamics.crm.entity.collection.request.ActioncardCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypartyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostfollowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostregardingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlakpiinstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class PhonecallRequest extends EntityRequest<Phonecall> {

    public PhonecallRequest(ContextPath contextPath, Optional<Object> value) {
        super(Phonecall.class, contextPath, value, false);
    }

    public PostregardingRequest phonecall_PostRegardings(UUID postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("phonecall_PostRegardings").addKeys(new NameValue(postregardingid, UUID.class)), Optional.empty());
    }

    public PostregardingCollectionRequest phonecall_PostRegardings() {
        return new PostregardingCollectionRequest(
                        contextPath.addSegment("phonecall_PostRegardings"), Optional.empty());
    }

    public PostfollowRequest phonecall_PostFollows(UUID postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("phonecall_PostFollows").addKeys(new NameValue(postfollowid, UUID.class)), Optional.empty());
    }

    public PostfollowCollectionRequest phonecall_PostFollows() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("phonecall_PostFollows"), Optional.empty());
    }

    public KnowledgebaserecordRequest regardingobjectid_knowledgebaserecord_phonecall() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("regardingobjectid_knowledgebaserecord_phonecall"), Optional.empty());
    }

    public ActioncardRequest phonecall_actioncard(UUID actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("phonecall_actioncard").addKeys(new NameValue(actioncardid, UUID.class)), Optional.empty());
    }

    public ActioncardCollectionRequest phonecall_actioncard() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("phonecall_actioncard"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid_phonecall() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid_phonecall"), Optional.empty());
    }

    public ContactRequest regardingobjectid_contact_phonecall() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact_phonecall"), Optional.empty());
    }

    public SlaRequest sla_phonecall_sla() {
        return new SlaRequest(contextPath.addSegment("sla_phonecall_sla"), Optional.empty());
    }

    public BulkdeletefailureRequest phoneCall_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("PhoneCall_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest phoneCall_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("PhoneCall_BulkDeleteFailures"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby_phonecall() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby_phonecall"), Optional.empty());
    }

    public AsyncoperationRequest phoneCall_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("PhoneCall_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest phoneCall_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("PhoneCall_AsyncOperations"), Optional.empty());
    }

    public AccountRequest regardingobjectid_account_phonecall() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account_phonecall"), Optional.empty());
    }

    public SystemuserRequest createdby_phonecall() {
        return new SystemuserRequest(contextPath.addSegment("createdby_phonecall"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby_phonecall() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby_phonecall"), Optional.empty());
    }

    public ActivitypartyRequest phonecall_activity_parties(UUID activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("phonecall_activity_parties").addKeys(new NameValue(activitypartyid, UUID.class)), Optional.empty());
    }

    public ActivitypartyCollectionRequest phonecall_activity_parties() {
        return new ActivitypartyCollectionRequest(
                        contextPath.addSegment("phonecall_activity_parties"), Optional.empty());
    }

    public ProcesssessionRequest phoneCall_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("PhoneCall_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest phoneCall_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("PhoneCall_ProcessSessions"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit_phonecall() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit_phonecall"), Optional.empty());
    }

    public DuplicaterecordRequest phoneCall_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("PhoneCall_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest phoneCall_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("PhoneCall_DuplicateMatchingRecord"), Optional.empty());
    }

    public KnowledgearticleRequest regardingobjectid_knowledgearticle_phonecall() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle_phonecall"), Optional.empty());
    }

    public ProcessstageRequest stageid_processstage() {
        return new ProcessstageRequest(contextPath.addSegment("stageid_processstage"), Optional.empty());
    }

    public DuplicaterecordRequest phoneCall_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("PhoneCall_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest phoneCall_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("PhoneCall_DuplicateBaseRecord"), Optional.empty());
    }

    public ConnectionRequest phonecall_connections1(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("phonecall_connections1").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest phonecall_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("phonecall_connections1"), Optional.empty());
    }

    public ActivitypointerRequest activityid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("activityid_activitypointer"), Optional.empty());
    }

    public SlakpiinstanceRequest slakpiinstance_phonecall(UUID slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstance_phonecall").addKeys(new NameValue(slakpiinstanceid, UUID.class)), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest slakpiinstance_phonecall() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("slakpiinstance_phonecall"), Optional.empty());
    }

    public SlaRequest slainvokedid_phonecall_sla() {
        return new SlaRequest(contextPath.addSegment("slainvokedid_phonecall_sla"), Optional.empty());
    }

    public SyncerrorRequest phoneCall_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("PhoneCall_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest phoneCall_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("PhoneCall_SyncErrors"), Optional.empty());
    }

    public SystemuserRequest modifiedby_phonecall() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby_phonecall"), Optional.empty());
    }

    public TeamRequest owningteam_phonecall() {
        return new TeamRequest(contextPath.addSegment("owningteam_phonecall"), Optional.empty());
    }

    public QueueitemRequest phoneCall_QueueItem(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("PhoneCall_QueueItem").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public QueueitemCollectionRequest phoneCall_QueueItem() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("PhoneCall_QueueItem"), Optional.empty());
    }

    public AnnotationRequest phoneCall_Annotation(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("PhoneCall_Annotation").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest phoneCall_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("PhoneCall_Annotation"), Optional.empty());
    }

    public ConnectionRequest phonecall_connections2(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("phonecall_connections2").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest phonecall_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("phonecall_connections2"), Optional.empty());
    }

    public SystemuserRequest owninguser_phonecall() {
        return new SystemuserRequest(contextPath.addSegment("owninguser_phonecall"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest phonecall_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("phonecall_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest phonecall_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("phonecall_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalRequest ownerid_phonecall() {
        return new PrincipalRequest(contextPath.addSegment("ownerid_phonecall"), Optional.empty());
    }

}
