package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Solutioncomponentrelationshipconfiguration;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentrelationshipconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class SolutioncomponentrelationshipconfigurationCollectionRequest extends CollectionPageEntityRequest<Solutioncomponentrelationshipconfiguration, SolutioncomponentrelationshipconfigurationRequest>{

    protected ContextPath contextPath;

    public SolutioncomponentrelationshipconfigurationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Solutioncomponentrelationshipconfiguration.class, cp -> new SolutioncomponentrelationshipconfigurationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest solutioncomponentrelationshipconfiguration_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("solutioncomponentrelationshipconfiguration_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest solutioncomponentrelationshipconfiguration_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("solutioncomponentrelationshipconfiguration_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest solutioncomponentrelationshipconfiguration_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("solutioncomponentrelationshipconfiguration_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest solutioncomponentrelationshipconfiguration_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("solutioncomponentrelationshipconfiguration_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest solutioncomponentrelationshipconfiguration_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("solutioncomponentrelationshipconfiguration_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest solutioncomponentrelationshipconfiguration_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("solutioncomponentrelationshipconfiguration_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest solutioncomponentrelationshipconfiguration_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("solutioncomponentrelationshipconfiguration_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest solutioncomponentrelationshipconfiguration_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("solutioncomponentrelationshipconfiguration_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest solutioncomponentrelationshipconfiguration_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("solutioncomponentrelationshipconfiguration_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest solutioncomponentrelationshipconfiguration_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("solutioncomponentrelationshipconfiguration_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest solutioncomponentrelationshipconfiguration_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("solutioncomponentrelationshipconfiguration_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest solutioncomponentrelationshipconfiguration_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("solutioncomponentrelationshipconfiguration_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest solutioncomponentrelationshipconfiguration_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("solutioncomponentrelationshipconfiguration_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest solutioncomponentrelationshipconfiguration_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("solutioncomponentrelationshipconfiguration_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest solutioncomponentrelationshipconfiguration_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("solutioncomponentrelationshipconfiguration_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest solutioncomponentrelationshipconfiguration_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("solutioncomponentrelationshipconfiguration_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

}
