package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Msdyn_aibdataset;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetrecordRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class Msdyn_aibdatasetCollectionRequest extends CollectionPageEntityRequest<Msdyn_aibdataset, Msdyn_aibdatasetRequest>{

    protected ContextPath contextPath;

    public Msdyn_aibdatasetCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Msdyn_aibdataset.class, cp -> new Msdyn_aibdatasetRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest msdyn_aibdataset_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_aibdataset_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_aibdataset_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("msdyn_aibdataset_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_aibdataset_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_aibdataset_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_aibdataset_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_aibdataset_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_aibdataset_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_aibdataset_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_aibdataset_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_aibdataset_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_aibdataset_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_aibdataset_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_aibdataset_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("msdyn_aibdataset_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_aibdataset_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_aibdataset_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_aibdataset_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("msdyn_aibdataset_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_aibdataset_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_aibdataset_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_aibdataset_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("msdyn_aibdataset_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_aibdataset_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_aibdataset_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_aibdataset_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("msdyn_aibdataset_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_aibdataset_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_aibdataset_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_aibdataset_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("msdyn_aibdataset_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public Msdyn_aibdatasetfileRequest msdyn_AIBDatasetFile_msdyn_AIBDatas(UUID msdyn_aibdatasetfileid) {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("msdyn_AIBDatasetFile_msdyn_AIBDatas").addKeys(new NameValue(msdyn_aibdatasetfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetfileCollectionRequest msdyn_AIBDatasetFile_msdyn_AIBDatas() {
        return new Msdyn_aibdatasetfileCollectionRequest(contextPath.addSegment("msdyn_AIBDatasetFile_msdyn_AIBDatas"), Optional.empty());
    }

    public Msdyn_aibdatasetrecordRequest msdyn_AIBDatasetRecord_msdyn_AIBDataset(UUID msdyn_aibdatasetrecordid) {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("msdyn_AIBDatasetRecord_msdyn_AIBDataset").addKeys(new NameValue(msdyn_aibdatasetrecordid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetrecordCollectionRequest msdyn_AIBDatasetRecord_msdyn_AIBDataset() {
        return new Msdyn_aibdatasetrecordCollectionRequest(contextPath.addSegment("msdyn_AIBDatasetRecord_msdyn_AIBDataset"), Optional.empty());
    }

}
