package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Knowledgearticle;
import microsoft.dynamics.crm.entity.request.ActivitypartyRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.CategoryRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.ExpiredprocessRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.FeedbackRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleviewsRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.NewprocessRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.PostfollowRequest;
import microsoft.dynamics.crm.entity.request.PostregardingRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.SharepointdocumentlocationRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TranslationprocessRequest;

public class KnowledgearticleCollectionRequest extends CollectionPageEntityRequest<Knowledgearticle, KnowledgearticleRequest>{

    protected ContextPath contextPath;

    public KnowledgearticleCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Knowledgearticle.class, cp -> new KnowledgearticleRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ConnectionRequest knowledgearticle_connections1(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("knowledgearticle_connections1").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest knowledgearticle_connections1() {
        return new ConnectionCollectionRequest(contextPath.addSegment("knowledgearticle_connections1"), Optional.empty());
    }

    public ConnectionRequest knowledgearticle_connections2(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("knowledgearticle_connections2").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest knowledgearticle_connections2() {
        return new ConnectionCollectionRequest(contextPath.addSegment("knowledgearticle_connections2"), Optional.empty());
    }

    public DuplicaterecordRequest knowledgearticle_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("knowledgearticle_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest knowledgearticle_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("knowledgearticle_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest knowledgearticle_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("knowledgearticle_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest knowledgearticle_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("knowledgearticle_DuplicateBaseRecord"), Optional.empty());
    }

    public SharepointdocumentlocationRequest knowledgearticle_SharePointDocumentLocations(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("knowledgearticle_SharePointDocumentLocations").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest knowledgearticle_SharePointDocumentLocations() {
        return new SharepointdocumentlocationCollectionRequest(contextPath.addSegment("knowledgearticle_SharePointDocumentLocations"), Optional.empty());
    }

    public QueueitemRequest knowledgearticle_QueueItems(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("knowledgearticle_QueueItems").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public QueueitemCollectionRequest knowledgearticle_QueueItems() {
        return new QueueitemCollectionRequest(contextPath.addSegment("knowledgearticle_QueueItems"), Optional.empty());
    }

    public AnnotationRequest knowledgearticle_Annotations(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("knowledgearticle_Annotations").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest knowledgearticle_Annotations() {
        return new AnnotationCollectionRequest(contextPath.addSegment("knowledgearticle_Annotations"), Optional.empty());
    }

    public TeamRequest knowledgearticle_Teams(UUID ownerid) {
        return new TeamRequest(contextPath.addSegment("knowledgearticle_Teams").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public TeamCollectionRequest knowledgearticle_Teams() {
        return new TeamCollectionRequest(contextPath.addSegment("knowledgearticle_Teams"), Optional.empty());
    }

    public AsyncoperationRequest knowledgearticle_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("knowledgearticle_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest knowledgearticle_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("knowledgearticle_AsyncOperations"), Optional.empty());
    }

    public ProcesssessionRequest knowledgearticle_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("knowledgearticle_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest knowledgearticle_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("knowledgearticle_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest knowledgearticle_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("knowledgearticle_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest knowledgearticle_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("knowledgearticle_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest knowledgearticle_PrincipalObjectAttributeAccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("knowledgearticle_PrincipalObjectAttributeAccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest knowledgearticle_PrincipalObjectAttributeAccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("knowledgearticle_PrincipalObjectAttributeAccess"), Optional.empty());
    }

    public ExpiredprocessRequest knowledgearticle_expiredprocess(UUID businessprocessflowinstanceid) {
        return new ExpiredprocessRequest(contextPath.addSegment("knowledgearticle_expiredprocess").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public ExpiredprocessCollectionRequest knowledgearticle_expiredprocess() {
        return new ExpiredprocessCollectionRequest(contextPath.addSegment("knowledgearticle_expiredprocess"), Optional.empty());
    }

    public TranslationprocessRequest knowledgearticle_translationprocess(UUID businessprocessflowinstanceid) {
        return new TranslationprocessRequest(contextPath.addSegment("knowledgearticle_translationprocess").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public TranslationprocessCollectionRequest knowledgearticle_translationprocess() {
        return new TranslationprocessCollectionRequest(contextPath.addSegment("knowledgearticle_translationprocess"), Optional.empty());
    }

    public SyncerrorRequest knowledgeArticle_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("KnowledgeArticle_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest knowledgeArticle_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("KnowledgeArticle_SyncErrors"), Optional.empty());
    }

    public RecurringappointmentmasterRequest knowledgeArticle_RecurringAppointmentMasters(UUID activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("KnowledgeArticle_RecurringAppointmentMasters").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest knowledgeArticle_RecurringAppointmentMasters() {
        return new RecurringappointmentmasterCollectionRequest(contextPath.addSegment("KnowledgeArticle_RecurringAppointmentMasters"), Optional.empty());
    }

    public LetterRequest knowledgeArticle_Letters(UUID activityid) {
        return new LetterRequest(contextPath.addSegment("KnowledgeArticle_Letters").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public LetterCollectionRequest knowledgeArticle_Letters() {
        return new LetterCollectionRequest(contextPath.addSegment("KnowledgeArticle_Letters"), Optional.empty());
    }

    public SocialactivityRequest knowledgeArticle_SocialActivities(UUID activityid) {
        return new SocialactivityRequest(contextPath.addSegment("KnowledgeArticle_SocialActivities").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public SocialactivityCollectionRequest knowledgeArticle_SocialActivities() {
        return new SocialactivityCollectionRequest(contextPath.addSegment("KnowledgeArticle_SocialActivities"), Optional.empty());
    }

    public ActivitypointerRequest knowledgeArticle_ActivityPointers(UUID activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("KnowledgeArticle_ActivityPointers").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public ActivitypointerCollectionRequest knowledgeArticle_ActivityPointers() {
        return new ActivitypointerCollectionRequest(contextPath.addSegment("KnowledgeArticle_ActivityPointers"), Optional.empty());
    }

    public NewprocessRequest knowledgearticle_newprocess(UUID businessprocessflowinstanceid) {
        return new NewprocessRequest(contextPath.addSegment("knowledgearticle_newprocess").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public NewprocessCollectionRequest knowledgearticle_newprocess() {
        return new NewprocessCollectionRequest(contextPath.addSegment("knowledgearticle_newprocess"), Optional.empty());
    }

    public FaxRequest knowledgeArticle_Faxes(UUID activityid) {
        return new FaxRequest(contextPath.addSegment("KnowledgeArticle_Faxes").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public FaxCollectionRequest knowledgeArticle_Faxes() {
        return new FaxCollectionRequest(contextPath.addSegment("KnowledgeArticle_Faxes"), Optional.empty());
    }

    public KnowledgearticleRequest knowledgearticle_previousarticle_contentid(UUID knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("knowledgearticle_previousarticle_contentid").addKeys(new NameValue(knowledgearticleid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleCollectionRequest knowledgearticle_previousarticle_contentid() {
        return new KnowledgearticleCollectionRequest(contextPath.addSegment("knowledgearticle_previousarticle_contentid"), Optional.empty());
    }

    public KnowledgearticleRequest knowledgearticle_rootarticle_id(UUID knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("knowledgearticle_rootarticle_id").addKeys(new NameValue(knowledgearticleid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleCollectionRequest knowledgearticle_rootarticle_id() {
        return new KnowledgearticleCollectionRequest(contextPath.addSegment("knowledgearticle_rootarticle_id"), Optional.empty());
    }

    public KnowledgearticleviewsRequest knowledgearticle_views(UUID knowledgearticleviewsid) {
        return new KnowledgearticleviewsRequest(contextPath.addSegment("knowledgearticle_views").addKeys(new NameValue(knowledgearticleviewsid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleviewsCollectionRequest knowledgearticle_views() {
        return new KnowledgearticleviewsCollectionRequest(contextPath.addSegment("knowledgearticle_views"), Optional.empty());
    }

    public PhonecallRequest knowledgeArticle_Phonecalls(UUID activityid) {
        return new PhonecallRequest(contextPath.addSegment("KnowledgeArticle_Phonecalls").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public PhonecallCollectionRequest knowledgeArticle_Phonecalls() {
        return new PhonecallCollectionRequest(contextPath.addSegment("KnowledgeArticle_Phonecalls"), Optional.empty());
    }

    public KnowledgearticleRequest knowledgearticle_parentarticle_contentid(UUID knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("knowledgearticle_parentarticle_contentid").addKeys(new NameValue(knowledgearticleid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleCollectionRequest knowledgearticle_parentarticle_contentid() {
        return new KnowledgearticleCollectionRequest(contextPath.addSegment("knowledgearticle_parentarticle_contentid"), Optional.empty());
    }

    public CategoryRequest knowledgearticle_category(UUID categoryid) {
        return new CategoryRequest(contextPath.addSegment("knowledgearticle_category").addKeys(new NameValue(categoryid, UUID.class)), Optional.empty());
    }

    public CategoryCollectionRequest knowledgearticle_category() {
        return new CategoryCollectionRequest(contextPath.addSegment("knowledgearticle_category"), Optional.empty());
    }

    public ActivitypartyRequest knowledgearticle_activity_parties(UUID activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("knowledgearticle_activity_parties").addKeys(new NameValue(activitypartyid, UUID.class)), Optional.empty());
    }

    public ActivitypartyCollectionRequest knowledgearticle_activity_parties() {
        return new ActivitypartyCollectionRequest(contextPath.addSegment("knowledgearticle_activity_parties"), Optional.empty());
    }

    public EmailRequest knowledgeArticle_Emails(UUID activityid) {
        return new EmailRequest(contextPath.addSegment("KnowledgeArticle_Emails").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public EmailCollectionRequest knowledgeArticle_Emails() {
        return new EmailCollectionRequest(contextPath.addSegment("KnowledgeArticle_Emails"), Optional.empty());
    }

    public TaskRequest knowledgeArticle_Tasks(UUID activityid) {
        return new TaskRequest(contextPath.addSegment("KnowledgeArticle_Tasks").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public TaskCollectionRequest knowledgeArticle_Tasks() {
        return new TaskCollectionRequest(contextPath.addSegment("KnowledgeArticle_Tasks"), Optional.empty());
    }

    public AppointmentRequest knowledgeArticle_Appointments(UUID activityid) {
        return new AppointmentRequest(contextPath.addSegment("KnowledgeArticle_Appointments").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public AppointmentCollectionRequest knowledgeArticle_Appointments() {
        return new AppointmentCollectionRequest(contextPath.addSegment("KnowledgeArticle_Appointments"), Optional.empty());
    }

    public PostregardingRequest knowledgearticle_PostRegardings(UUID postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("knowledgearticle_PostRegardings").addKeys(new NameValue(postregardingid, UUID.class)), Optional.empty());
    }

    public PostregardingCollectionRequest knowledgearticle_PostRegardings() {
        return new PostregardingCollectionRequest(contextPath.addSegment("knowledgearticle_PostRegardings"), Optional.empty());
    }

    public PostfollowRequest knowledgearticle_PostFollows(UUID postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("knowledgearticle_PostFollows").addKeys(new NameValue(postfollowid, UUID.class)), Optional.empty());
    }

    public PostfollowCollectionRequest knowledgearticle_PostFollows() {
        return new PostfollowCollectionRequest(contextPath.addSegment("knowledgearticle_PostFollows"), Optional.empty());
    }

    public FeedbackRequest knowledgeArticle_Feedback(UUID feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("KnowledgeArticle_Feedback").addKeys(new NameValue(feedbackid, UUID.class)), Optional.empty());
    }

    public FeedbackCollectionRequest knowledgeArticle_Feedback() {
        return new FeedbackCollectionRequest(contextPath.addSegment("KnowledgeArticle_Feedback"), Optional.empty());
    }

}
