package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Kbarticlecomment;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.KbarticlecommentRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;

public class KbarticlecommentCollectionRequest extends CollectionPageEntityRequest<Kbarticlecomment, KbarticlecommentRequest>{

    protected ContextPath contextPath;

    public KbarticlecommentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Kbarticlecomment.class, cp -> new KbarticlecommentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public BulkdeletefailureRequest kbArticleComment_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("KbArticleComment_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest kbArticleComment_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("KbArticleComment_BulkDeleteFailures"), Optional.empty());
    }

    public AsyncoperationRequest kbArticleComment_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("KbArticleComment_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest kbArticleComment_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("KbArticleComment_AsyncOperations"), Optional.empty());
    }

    public ProcesssessionRequest kbArticleComment_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("KbArticleComment_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest kbArticleComment_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("KbArticleComment_ProcessSessions"), Optional.empty());
    }

}
