package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Kbarticle;
import microsoft.dynamics.crm.entity.Subject;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.KbarticleRequest;
import microsoft.dynamics.crm.entity.request.KbarticlecommentRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SharepointdocumentlocationRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class KbarticleCollectionRequest extends CollectionPageEntityRequest<Kbarticle, KbarticleRequest>{

    protected ContextPath contextPath;

    public KbarticleCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Kbarticle.class, cp -> new KbarticleRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AnnotationRequest kbArticle_Annotation(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("KbArticle_Annotation").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest kbArticle_Annotation() {
        return new AnnotationCollectionRequest(contextPath.addSegment("KbArticle_Annotation"), Optional.empty());
    }

    public BulkdeletefailureRequest kbArticle_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("KbArticle_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest kbArticle_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("KbArticle_BulkDeleteFailures"), Optional.empty());
    }

    public AsyncoperationRequest kbArticle_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("KbArticle_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest kbArticle_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("KbArticle_AsyncOperations"), Optional.empty());
    }

    public ProcesssessionRequest kbArticle_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("KbArticle_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest kbArticle_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("KbArticle_ProcessSessions"), Optional.empty());
    }

    public DuplicaterecordRequest kbArticle_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("KbArticle_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest kbArticle_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("KbArticle_DuplicateMatchingRecord"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest kbarticle_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("kbarticle_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest kbarticle_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("kbarticle_principalobjectattributeaccess"), Optional.empty());
    }

    public DuplicaterecordRequest kbArticle_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("KbArticle_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest kbArticle_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("KbArticle_DuplicateBaseRecord"), Optional.empty());
    }

    public SharepointdocumentlocationRequest kbArticle_SharepointDocumentLocation(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("KbArticle_SharepointDocumentLocation").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest kbArticle_SharepointDocumentLocation() {
        return new SharepointdocumentlocationCollectionRequest(contextPath.addSegment("KbArticle_SharepointDocumentLocation"), Optional.empty());
    }

    public KbarticlecommentRequest kbarticle_comments(UUID kbarticlecommentid) {
        return new KbarticlecommentRequest(contextPath.addSegment("kbarticle_comments").addKeys(new NameValue(kbarticlecommentid, UUID.class)), Optional.empty());
    }

    public KbarticlecommentCollectionRequest kbarticle_comments() {
        return new KbarticlecommentCollectionRequest(contextPath.addSegment("kbarticle_comments"), Optional.empty());
    }

    public SyncerrorRequest kbArticle_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("KbArticle_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest kbArticle_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("KbArticle_SyncErrors"), Optional.empty());
    }

    @Function(name = "SearchByBodyKbArticle")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Kbarticle> searchByBodyKbArticle(String searchText, Subject subject, Boolean useInflection) {
        Preconditions.checkNotNull(searchText, "searchText cannot be null");
        Preconditions.checkNotNull(subject, "subject cannot be null");
        Preconditions.checkNotNull(useInflection, "useInflection cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchText", "Edm.String", Checks.checkIsAscii(searchText))
            .put("Subject", "Microsoft.Dynamics.CRM.subject", subject)
            .put("UseInflection", "Edm.Boolean", useInflection)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SearchByBodyKbArticle"), Kbarticle.class, _parameters);
    }

    @Function(name = "SearchByKeywordsKbArticle")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Kbarticle> searchByKeywordsKbArticle(String searchText, Subject subject, Boolean useInflection) {
        Preconditions.checkNotNull(searchText, "searchText cannot be null");
        Preconditions.checkNotNull(subject, "subject cannot be null");
        Preconditions.checkNotNull(useInflection, "useInflection cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchText", "Edm.String", Checks.checkIsAscii(searchText))
            .put("Subject", "Microsoft.Dynamics.CRM.subject", subject)
            .put("UseInflection", "Edm.Boolean", useInflection)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SearchByKeywordsKbArticle"), Kbarticle.class, _parameters);
    }

    @Function(name = "SearchByTitleKbArticle")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Kbarticle> searchByTitleKbArticle(String searchText, Subject subject, Boolean useInflection) {
        Preconditions.checkNotNull(searchText, "searchText cannot be null");
        Preconditions.checkNotNull(subject, "subject cannot be null");
        Preconditions.checkNotNull(useInflection, "useInflection cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchText", "Edm.String", Checks.checkIsAscii(searchText))
            .put("Subject", "Microsoft.Dynamics.CRM.subject", subject)
            .put("UseInflection", "Edm.Boolean", useInflection)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SearchByTitleKbArticle"), Kbarticle.class, _parameters);
    }

}
