package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Goalrollupquery;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.GoalRequest;
import microsoft.dynamics.crm.entity.request.GoalrollupqueryRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class GoalrollupqueryCollectionRequest extends CollectionPageEntityRequest<Goalrollupquery, GoalrollupqueryRequest>{

    protected ContextPath contextPath;

    public GoalrollupqueryCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Goalrollupquery.class, cp -> new GoalrollupqueryRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public GoalRequest goalrollupquery_actualint(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("goalrollupquery_actualint").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest goalrollupquery_actualint() {
        return new GoalCollectionRequest(contextPath.addSegment("goalrollupquery_actualint"), Optional.empty());
    }

    public GoalRequest goal_rollupquery_actualmoney(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("goal_rollupquery_actualmoney").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest goal_rollupquery_actualmoney() {
        return new GoalCollectionRequest(contextPath.addSegment("goal_rollupquery_actualmoney"), Optional.empty());
    }

    public GoalRequest goal_rollupquery_actualdecimal(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("goal_rollupquery_actualdecimal").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest goal_rollupquery_actualdecimal() {
        return new GoalCollectionRequest(contextPath.addSegment("goal_rollupquery_actualdecimal"), Optional.empty());
    }

    public GoalRequest goal_rollupquery_customint(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("goal_rollupquery_customint").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest goal_rollupquery_customint() {
        return new GoalCollectionRequest(contextPath.addSegment("goal_rollupquery_customint"), Optional.empty());
    }

    public GoalRequest goal_rollupquery_custommoney(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("goal_rollupquery_custommoney").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest goal_rollupquery_custommoney() {
        return new GoalCollectionRequest(contextPath.addSegment("goal_rollupquery_custommoney"), Optional.empty());
    }

    public GoalRequest goal_rollupquery_customdecimal(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("goal_rollupquery_customdecimal").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest goal_rollupquery_customdecimal() {
        return new GoalCollectionRequest(contextPath.addSegment("goal_rollupquery_customdecimal"), Optional.empty());
    }

    public GoalRequest goal_rollupquery_inprogressint(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("goal_rollupquery_inprogressint").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest goal_rollupquery_inprogressint() {
        return new GoalCollectionRequest(contextPath.addSegment("goal_rollupquery_inprogressint"), Optional.empty());
    }

    public GoalRequest goal_rollupquery_inprogressmoney(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("goal_rollupquery_inprogressmoney").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest goal_rollupquery_inprogressmoney() {
        return new GoalCollectionRequest(contextPath.addSegment("goal_rollupquery_inprogressmoney"), Optional.empty());
    }

    public GoalRequest goal_rollupquery_inprogressdecimal(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("goal_rollupquery_inprogressdecimal").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest goal_rollupquery_inprogressdecimal() {
        return new GoalCollectionRequest(contextPath.addSegment("goal_rollupquery_inprogressdecimal"), Optional.empty());
    }

    public DuplicaterecordRequest goalRollupQuery_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("GoalRollupQuery_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest goalRollupQuery_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("GoalRollupQuery_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest goalrollupquery_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("goalrollupquery_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest goalrollupquery_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("goalrollupquery_AsyncOperations"), Optional.empty());
    }

    public DuplicaterecordRequest goalRollupQuery_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("GoalRollupQuery_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest goalRollupQuery_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("GoalRollupQuery_DuplicateMatchingRecord"), Optional.empty());
    }

    public ProcesssessionRequest goalrollupquery_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("goalrollupquery_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest goalrollupquery_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("goalrollupquery_ProcessSessions"), Optional.empty());
    }

    public SyncerrorRequest goalRollupQuery_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("GoalRollupQuery_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest goalRollupQuery_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("GoalRollupQuery_SyncErrors"), Optional.empty());
    }

}
