package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Environmentvariablevalue;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariablevalueRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class EnvironmentvariablevalueCollectionRequest extends CollectionPageEntityRequest<Environmentvariablevalue, EnvironmentvariablevalueRequest>{

    protected ContextPath contextPath;

    public EnvironmentvariablevalueCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Environmentvariablevalue.class, cp -> new EnvironmentvariablevalueRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest environmentvariablevalue_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("environmentvariablevalue_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest environmentvariablevalue_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("environmentvariablevalue_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest environmentvariablevalue_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("environmentvariablevalue_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest environmentvariablevalue_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("environmentvariablevalue_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest environmentvariablevalue_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("environmentvariablevalue_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest environmentvariablevalue_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("environmentvariablevalue_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest environmentvariablevalue_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("environmentvariablevalue_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest environmentvariablevalue_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("environmentvariablevalue_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest environmentvariablevalue_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("environmentvariablevalue_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest environmentvariablevalue_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("environmentvariablevalue_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest environmentvariablevalue_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("environmentvariablevalue_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest environmentvariablevalue_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("environmentvariablevalue_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest environmentvariablevalue_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("environmentvariablevalue_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest environmentvariablevalue_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("environmentvariablevalue_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest environmentvariablevalue_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("environmentvariablevalue_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest environmentvariablevalue_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("environmentvariablevalue_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

}
