package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Duplicaterulecondition;
import microsoft.dynamics.crm.entity.request.DuplicateruleconditionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class DuplicateruleconditionCollectionRequest extends CollectionPageEntityRequest<Duplicaterulecondition, DuplicateruleconditionRequest>{

    protected ContextPath contextPath;

    public DuplicateruleconditionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Duplicaterulecondition.class, cp -> new DuplicateruleconditionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest duplicateRuleCondition_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("DuplicateRuleCondition_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest duplicateRuleCondition_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("DuplicateRuleCondition_SyncErrors"), Optional.empty());
    }

}
