package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Attributeimageconfig;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.AttributeimageconfigRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class AttributeimageconfigCollectionRequest extends CollectionPageEntityRequest<Attributeimageconfig, AttributeimageconfigRequest>{

    protected ContextPath contextPath;

    public AttributeimageconfigCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Attributeimageconfig.class, cp -> new AttributeimageconfigRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest attributeimageconfig_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("attributeimageconfig_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest attributeimageconfig_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("attributeimageconfig_SyncErrors"), Optional.empty());
    }

    public AsyncoperationRequest attributeimageconfig_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("attributeimageconfig_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest attributeimageconfig_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("attributeimageconfig_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest attributeimageconfig_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("attributeimageconfig_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest attributeimageconfig_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("attributeimageconfig_MailboxTrackingFolders"), Optional.empty());
    }

    public BulkdeletefailureRequest attributeimageconfig_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("attributeimageconfig_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest attributeimageconfig_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("attributeimageconfig_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest attributeimageconfig_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("attributeimageconfig_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest attributeimageconfig_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("attributeimageconfig_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

}
