package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Applicationuser;
import microsoft.dynamics.crm.entity.request.ApplicationuserRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.RoleRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class ApplicationuserCollectionRequest extends CollectionPageEntityRequest<Applicationuser, ApplicationuserRequest>{

    protected ContextPath contextPath;

    public ApplicationuserCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Applicationuser.class, cp -> new ApplicationuserRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest applicationuser_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("applicationuser_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest applicationuser_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("applicationuser_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest applicationuser_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("applicationuser_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest applicationuser_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("applicationuser_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest applicationuser_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("applicationuser_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest applicationuser_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("applicationuser_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest applicationuser_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("applicationuser_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest applicationuser_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("applicationuser_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest applicationuser_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("applicationuser_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest applicationuser_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("applicationuser_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest applicationuser_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("applicationuser_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest applicationuser_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("applicationuser_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest applicationuser_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("applicationuser_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest applicationuser_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("applicationuser_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest applicationuser_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("applicationuser_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest applicationuser_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("applicationuser_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public RoleRequest applicationuserrole(UUID roleid) {
        return new RoleRequest(contextPath.addSegment("applicationuserrole").addKeys(new NameValue(roleid, UUID.class)), Optional.empty());
    }

    public RoleCollectionRequest applicationuserrole() {
        return new RoleCollectionRequest(contextPath.addSegment("applicationuserrole"), Optional.empty());
    }

}
